/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class SessionInfos {
    private final String username;
    private final long userId;

    public SessionInfos(String username, long userId) {
        this.username = username;
        this.userId = userId;
    }

    public long getUserId() {
        return this.userId;
    }

    public String getUsername() {
        return this.username;
    }

    public static SessionInfos getSessionInfos() {
        SSession session = SessionInfos.getSession();
        if (session != null) {
            return new SessionInfos(session.getUserName(), session.getUserId());
        }
        return new SessionInfos("system", -1L);
    }

    public static SSession getSession() {
        SSession session;
        try {
            SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
            long sessionId = sessionAccessor.getSessionId();
            PlatformServiceAccessor platformServiceAccessor = ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
            session = platformServiceAccessor.getSessionService().getSession(sessionId);
        }
        catch (SessionIdNotSetException e) {
            return null;
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
        return session;
    }

    public static long getUserIdFromSession() {
        SSession session = SessionInfos.getSession();
        if (session == null) {
            return -1L;
        }
        return session.getUserId();
    }

    public static String getUserNameFromSession() {
        SSession session = SessionInfos.getSession();
        if (session == null) {
            return "system";
        }
        return session.getUserName();
    }
}

