/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.category;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.category.CategoryService;
import org.bonitasoft.engine.core.category.model.SProcessCategoryMapping;
import org.bonitasoft.engine.core.category.model.builder.SProcessCategoryMappingBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;

public class RemoveProcessDefinitionsOfCategory
implements TransactionContent {
    private final CategoryService categoryService;
    private final long categoryId;
    private final long processDefinitionId;

    public RemoveProcessDefinitionsOfCategory(CategoryService categoryService, long categoryId) {
        this.categoryService = categoryService;
        this.categoryId = categoryId;
        this.processDefinitionId = -1L;
    }

    public RemoveProcessDefinitionsOfCategory(long processDefinitionId, CategoryService categoryService) {
        this.processDefinitionId = processDefinitionId;
        this.categoryService = categoryService;
        this.categoryId = -1L;
    }

    @Override
    public void execute() throws SBonitaException {
        List<SProcessCategoryMapping> processCategoryMappings;
        long deletedProcessCategoryMappings;
        FilterOption filterOption = this.categoryId != -1L ? new FilterOption(SProcessCategoryMapping.class, BuilderFactory.get(SProcessCategoryMappingBuilderFactory.class).getCategoryIdKey(), this.categoryId) : new FilterOption(SProcessCategoryMapping.class, BuilderFactory.get(SProcessCategoryMappingBuilderFactory.class).getProcessIdKey(), this.processDefinitionId);
        OrderByOption order = new OrderByOption(SProcessCategoryMapping.class, BuilderFactory.get(SProcessCategoryMappingBuilderFactory.class).getIdKey(), OrderByType.ASC);
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(order), Collections.singletonList(filterOption), null);
        while ((deletedProcessCategoryMappings = this.categoryService.deleteProcessCategoryMappings(processCategoryMappings = this.categoryService.searchProcessCategoryMappings(queryOptions))) > 0L) {
        }
    }
}

