/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.identity;

import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.model.SUserMembership;

public class GetUserMembership
implements TransactionContentWithResult<SUserMembership> {
    private final IdentityService identityService;
    private final long userId;
    private SUserMembership sUserMembership;
    private final long groupId;
    private final long roleId;
    private final long userMembershipId;

    public GetUserMembership(long userId, long groupId, long roleId, IdentityService identityService) {
        this.userId = userId;
        this.groupId = groupId;
        this.roleId = roleId;
        this.identityService = identityService;
        this.userMembershipId = -1L;
    }

    public GetUserMembership(long userMembershipId, IdentityService identityService) {
        this.userMembershipId = userMembershipId;
        this.identityService = identityService;
        this.userId = -1L;
        this.groupId = -1L;
        this.roleId = -1L;
    }

    @Override
    public void execute() throws SBonitaException {
        this.sUserMembership = this.userMembershipId == -1L ? this.identityService.getUserMembership(this.userId, this.groupId, this.roleId) : this.identityService.getUserMembership(this.userMembershipId);
    }

    @Override
    public SUserMembership getResult() {
        return this.sUserMembership;
    }
}

