/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class DeleteArchivedProcessInstances
implements TransactionContent {
    private static final int BATCH_SIZE = 100;
    private final ProcessInstanceService processInstanceService;
    private final long processDefinitionId;

    public DeleteArchivedProcessInstances(TenantServiceAccessor tenantAccessor, long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        this.processInstanceService = tenantAccessor.getProcessInstanceService();
    }

    @Override
    public void execute() throws SBonitaException {
        this.deleteArchivedProcessInstancesFromDefinition(this.processDefinitionId);
    }

    public void deleteArchivedProcessInstancesFromDefinition(long processDefinitionId) throws SBonitaException {
        List<Long> sourceProcessInstanceIds;
        do {
            sourceProcessInstanceIds = this.processInstanceService.getSourceProcesInstanceIdsOfArchProcessInstancesFromDefinition(processDefinitionId, 0, 100, OrderByType.DESC);
            for (Long orgProcessId : sourceProcessInstanceIds) {
                this.processInstanceService.deleteArchivedProcessInstanceElements(orgProcessId, processDefinitionId);
                this.processInstanceService.deleteArchivedProcessInstancesOfProcessInstance(orgProcessId);
            }
        } while (!sourceProcessInstanceIds.isEmpty());
    }

    protected long getProcessDefinitionId() {
        return this.processDefinitionId;
    }
}

