/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.util.Map;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoUpdater;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContent;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoUpdateBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoUpdateBuilderFactory;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class UpdateProcessDeploymentInfo
implements TransactionContent {
    private final ProcessDefinitionService processDefinitionService;
    private final long processId;
    private final ProcessDeploymentInfoUpdater processDeploymentInfoUpdateDescriptor;

    public UpdateProcessDeploymentInfo(ProcessDefinitionService processDefinitionService, long processId, ProcessDeploymentInfoUpdater processDeploymentInfoUpdateDescriptor) {
        this.processDefinitionService = processDefinitionService;
        this.processId = processId;
        this.processDeploymentInfoUpdateDescriptor = processDeploymentInfoUpdateDescriptor;
    }

    @Override
    public void execute() throws SBonitaException {
        this.processDefinitionService.updateProcessDefinitionDeployInfo(this.processId, this.buildDescriptor());
    }

    private EntityUpdateDescriptor buildDescriptor() {
        SProcessDefinitionDeployInfoUpdateBuilder processDeploymentInfoUpdateBuilder = BuilderFactory.get(SProcessDefinitionDeployInfoUpdateBuilderFactory.class).createNewInstance();
        Map updatedFieldsMap = this.processDeploymentInfoUpdateDescriptor.getFields();
        for (Map.Entry field : updatedFieldsMap.entrySet()) {
            switch ((ProcessDeploymentInfoUpdater.ProcessDeploymentInfoField)field.getKey()) {
                case DISPLAY_NAME: {
                    processDeploymentInfoUpdateBuilder.updateDisplayName((String)field.getValue());
                    break;
                }
                case DISPLAY_DESCRIPTION: {
                    processDeploymentInfoUpdateBuilder.updateDisplayDescription((String)field.getValue());
                    break;
                }
                case ICONPATH: {
                    processDeploymentInfoUpdateBuilder.updateIconPath((String)field.getValue());
                    break;
                }
            }
        }
        return processDeploymentInfoUpdateBuilder.done();
    }
}

