/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.connector.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceCreationException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceDeletionException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceModificationException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceNotFoundException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstanceWithFailureInfo;
import org.bonitasoft.engine.core.process.instance.model.archive.SAConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAConnectorInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SConnectorInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SConnectorInstanceLogBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SConnectorInstanceLogBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SConnectorInstanceWithFailureInfoBuilderFactory;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class ConnectorInstanceServiceImpl
implements ConnectorInstanceService {
    private static final int MAX_MESSAGE_LENGTH = 255;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceService;
    private final EventService eventService;
    private final ArchiveService archiveService;

    public ConnectorInstanceServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, ArchiveService archiveService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.archiveService = archiveService;
        this.eventService = eventService;
    }

    @Override
    public void setState(SConnectorInstance sConnectorInstance, String state) throws SConnectorInstanceModificationException {
        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
        entityUpdateDescriptor.addField(BuilderFactory.get(SConnectorInstanceBuilderFactory.class).getStateKey(), state);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)sConnectorInstance, entityUpdateDescriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("CONNECTOR_INSTANCE_STATE", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("CONNECTOR_INSTANCE_STATE").setObject(sConnectorInstance).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SConnectorInstanceModificationException(e);
        }
    }

    @Override
    public void setConnectorInstanceFailureException(SConnectorInstanceWithFailureInfo connectorInstanceWithFailure, Throwable throwable) throws SConnectorInstanceModificationException {
        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
        entityUpdateDescriptor.addField(BuilderFactory.get(SConnectorInstanceWithFailureInfoBuilderFactory.class).getExceptionMessageKey(), this.getExceptionMessage(throwable));
        try {
            entityUpdateDescriptor.addField(BuilderFactory.get(SConnectorInstanceWithFailureInfoBuilderFactory.class).getStackTraceKey(), ConnectorInstanceServiceImpl.getStringStackTrace(throwable));
        }
        catch (IOException e) {
            throw new SConnectorInstanceModificationException(e);
        }
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)connectorInstanceWithFailure, entityUpdateDescriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("CONNECTOR_INSTANCE", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("CONNECTOR_INSTANCE").setObject(connectorInstanceWithFailure).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SConnectorInstanceModificationException(e);
        }
    }

    private String getExceptionMessage(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable current = throwable;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        String message = current.getMessage();
        if (message != null && message.length() > 255) {
            message = message.substring(0, 255);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringStackTrace(Throwable throwable) throws IOException {
        if (throwable == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        PrintWriter printer = null;
        try {
            printer = new PrintWriter(writer);
            throwable.printStackTrace(printer);
            String string = writer.toString();
            return string;
        }
        finally {
            if (printer != null) {
                printer.close();
            }
            writer.close();
        }
    }

    @Override
    public void createConnectorInstance(SConnectorInstance connectorInstance) throws SConnectorInstanceCreationException {
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("CONNECTOR_INSTANCE", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("CONNECTOR_INSTANCE").setObject(connectorInstance).done();
        }
        InsertRecord insertRecord = new InsertRecord(connectorInstance);
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SConnectorInstanceCreationException(e);
        }
    }

    @Override
    public List<SConnectorInstance> getConnectorInstances(long containerId, String containerType, ConnectorEvent activationEvent, int from, int numberOfResult, String state) throws SConnectorInstanceReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(4);
        inputParameters.put("containerId", containerId);
        inputParameters.put("containerType", containerType);
        inputParameters.put("activationEvent", activationEvent);
        inputParameters.put("state", state);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getConnectorInstancesWithState", inputParameters, SConnectorInstance.class, new QueryOptions(from, numberOfResult));
        try {
            return this.persistenceService.selectList(selectListDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    @Override
    public List<SConnectorInstance> getConnectorInstances(long containerId, String containerType, int from, int numberOfResult, String fieldName, OrderByType orderByType) throws SConnectorInstanceReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(2);
        inputParameters.put("containerId", containerId);
        inputParameters.put("containerType", containerType);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getConnectorInstances", inputParameters, SConnectorInstance.class, new QueryOptions(from, numberOfResult, SConnectorInstance.class, fieldName, orderByType));
        try {
            return this.persistenceService.selectList(selectListDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    private List<SConnectorInstance> getConnectorInstancesOrderedById(long containerId, String containerType, int from, int numberOfResult) throws SConnectorInstanceReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(2);
        inputParameters.put("containerId", containerId);
        inputParameters.put("containerType", containerType);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getConnectorInstancesOrderedById", inputParameters, SConnectorInstance.class, new QueryOptions(from, numberOfResult));
        try {
            return this.persistenceService.selectList(selectListDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    @Override
    public SConnectorInstance getNextExecutableConnectorInstance(long containerId, String containerType, ConnectorEvent activationEvent) throws SConnectorInstanceReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(3);
        inputParameters.put("containerId", containerId);
        inputParameters.put("containerType", containerType);
        inputParameters.put("activationEvent", activationEvent);
        SelectListDescriptor selectOneDescriptor = new SelectListDescriptor("getNextExecutableConnectorInstance", inputParameters, SConnectorInstance.class, new QueryOptions(0, 1));
        try {
            List selectList = this.persistenceService.selectList(selectOneDescriptor);
            if (selectList.size() == 1) {
                return (SConnectorInstance)selectList.get(0);
            }
            return null;
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    @Override
    public long getNumberOfConnectorInstances(long containerId, String containerType) throws SConnectorInstanceReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(2);
        inputParameters.put("containerId", containerId);
        inputParameters.put("containerType", containerType);
        SelectOneDescriptor selectListDescriptor = new SelectOneDescriptor("getNumberOfConnectorInstances", inputParameters, SConnectorInstance.class);
        try {
            return (Long)this.persistenceService.selectOne(selectListDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    @Override
    public SConnectorInstance getConnectorInstance(long connectorInstanceId) throws SConnectorInstanceReadException, SConnectorInstanceNotFoundException {
        SelectByIdDescriptor<SConnectorInstance> selectByIdDescriptor = new SelectByIdDescriptor<SConnectorInstance>("getConnectorInstance", SConnectorInstance.class, connectorInstanceId);
        try {
            SConnectorInstance connectorInstance = this.persistenceService.selectById(selectByIdDescriptor);
            if (connectorInstance == null) {
                throw new SConnectorInstanceNotFoundException(connectorInstanceId);
            }
            return connectorInstance;
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    @Override
    public SConnectorInstanceWithFailureInfo getConnectorInstanceWithFailureInfo(long connectorInstanceId) throws SConnectorInstanceReadException, SConnectorInstanceNotFoundException {
        SelectByIdDescriptor<SConnectorInstanceWithFailureInfo> selectByIdDescriptor = new SelectByIdDescriptor<SConnectorInstanceWithFailureInfo>("getConnectorInstanceWithFailureInfo", SConnectorInstanceWithFailureInfo.class, connectorInstanceId);
        try {
            SConnectorInstanceWithFailureInfo connectorInstance = this.persistenceService.selectById(selectByIdDescriptor);
            if (connectorInstance == null) {
                throw new SConnectorInstanceNotFoundException(connectorInstanceId);
            }
            return connectorInstance;
        }
        catch (SBonitaReadException e) {
            throw new SConnectorInstanceReadException(e);
        }
    }

    protected SConnectorInstanceLogBuilder getQueriableLog(ActionType actionType, String message, SConnectorInstance connectorInstance) {
        SConnectorInstanceLogBuilder logBuilder = BuilderFactory.get(SConnectorInstanceLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.containerId(connectorInstance.getContainerId());
        return logBuilder;
    }

    protected SConnectorInstanceLogBuilder getQueriableLog(ActionType actionType, String message, SAConnectorInstance connectorInstance) {
        SConnectorInstanceLogBuilder logBuilder = BuilderFactory.get(SConnectorInstanceLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.containerId(connectorInstance.getContainerId());
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public long getNumberOfConnectorInstances(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SConnectorInstance.class, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SConnectorInstance> searchConnectorInstances(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SConnectorInstance.class, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public void archiveConnectorInstance(SConnectorInstance connectorInstance, long archiveDate) throws SConnectorInstanceCreationException {
        if (connectorInstance != null) {
            SAConnectorInstance saConnectorInstance = BuilderFactory.get(SAConnectorInstanceBuilderFactory.class).createNewArchivedConnectorInstance(connectorInstance).done();
            ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saConnectorInstance);
            try {
                this.archiveService.recordInsert(archiveDate, insertRecord);
            }
            catch (SBonitaException e) {
                throw new SConnectorInstanceCreationException("Unable to archive the connectorInstance instance with id " + connectorInstance.getId(), e);
            }
        }
    }

    @Override
    public void deleteConnectorInstance(SConnectorInstance connectorInstance) throws SConnectorInstanceDeletionException {
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("CONNECTOR_INSTANCE", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("CONNECTOR_INSTANCE").setObject(connectorInstance).done();
        }
        DeleteRecord deleteRecord = new DeleteRecord(connectorInstance);
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SConnectorInstanceDeletionException(e);
        }
    }

    @Override
    public long getNumberArchivedConnectorInstance(QueryOptions searchOptions, ReadPersistenceService persistenceService) throws SBonitaSearchException {
        try {
            return persistenceService.getNumberOfEntities(SAConnectorInstance.class, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SAConnectorInstance> searchArchivedConnectorInstance(QueryOptions searchOptions, ReadPersistenceService persistenceService) throws SBonitaSearchException {
        try {
            return persistenceService.searchEntity(SAConnectorInstance.class, searchOptions, null);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public void deleteArchivedConnectorInstance(SAConnectorInstance sConnectorInstance) throws SConnectorInstanceDeletionException {
        SDeleteEvent deleteEvent = null;
        DeleteRecord deleteRecord = new DeleteRecord(sConnectorInstance);
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SConnectorInstanceDeletionException(e);
        }
    }

    @Override
    public void deleteArchivedConnectorInstances(long containerId, String containerType) throws SBonitaSearchException, SConnectorInstanceDeletionException {
        List<SAConnectorInstance> connectorInstances;
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        List<FilterOption> filters = this.buildFiltersForConnectors(containerId, containerType, true);
        OrderByOption orderBy = new OrderByOption(SAConnectorInstance.class, BuilderFactory.get(SConnectorInstanceBuilderFactory.class).getIdKey(), OrderByType.ASC);
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(orderBy), filters, null);
        do {
            connectorInstances = this.searchArchivedConnectorInstance(queryOptions, persistenceService);
            for (SAConnectorInstance sConnectorInstance : connectorInstances) {
                this.deleteArchivedConnectorInstance(sConnectorInstance);
            }
        } while (connectorInstances != null && !connectorInstances.isEmpty());
    }

    @Override
    public void deleteConnectors(long containerId, String containerType) throws SConnectorInstanceReadException, SConnectorInstanceDeletionException {
        List<SConnectorInstance> connetorInstances;
        do {
            connetorInstances = this.getConnectorInstancesOrderedById(containerId, containerType, 0, 100);
            for (SConnectorInstance sConnectorInstance : connetorInstances) {
                this.deleteConnectorInstance(sConnectorInstance);
            }
        } while (!connetorInstances.isEmpty());
    }

    private List<FilterOption> buildFiltersForConnectors(long containerId, String containerType, boolean archived) {
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>(2);
        Class persistentClass = archived ? SAConnectorInstance.class : SConnectorInstance.class;
        filters.add(new FilterOption(persistentClass, BuilderFactory.get(SConnectorInstanceBuilderFactory.class).getContainerIdKey(), containerId));
        filters.add(new FilterOption(persistentClass, BuilderFactory.get(SConnectorInstanceBuilderFactory.class).getContainerTypeKey(), containerType));
        return filters;
    }
}

