/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.FailAction;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.impl.SNamedElementImpl;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.operation.Operation;

public class SConnectorDefinitionImpl
extends SNamedElementImpl
implements SConnectorDefinition {
    private static final long serialVersionUID = 7953224084604802080L;
    private final ConnectorEvent activationEvent;
    private final Map<String, SExpression> inputs;
    private final List<SOperation> outputs;
    private final String connectorId;
    private final String version;
    private FailAction failAction;
    private String errorCode;

    public SConnectorDefinitionImpl(ConnectorDefinition connector) {
        super(connector.getName());
        this.activationEvent = connector.getActivationEvent();
        this.connectorId = connector.getConnectorId();
        this.version = connector.getVersion();
        this.failAction = connector.getFailAction();
        this.errorCode = connector.getErrorCode();
        this.inputs = new HashMap<String, SExpression>(connector.getInputs().size());
        for (Map.Entry input : connector.getInputs().entrySet()) {
            Expression value = (Expression)input.getValue();
            if (value == null) continue;
            SExpression sExpression = ServerModelConvertor.convertExpression(value);
            this.inputs.put((String)input.getKey(), sExpression);
        }
        this.outputs = new ArrayList<SOperation>(connector.getOutputs().size());
        for (Operation operation : connector.getOutputs()) {
            SOperation sOperation = ServerModelConvertor.convertOperation(operation);
            this.outputs.add(sOperation);
        }
    }

    public SConnectorDefinitionImpl(String name, String connectorId, String version, ConnectorEvent activationEvent) {
        super(name);
        this.connectorId = connectorId;
        this.version = version;
        this.activationEvent = activationEvent;
        this.inputs = new HashMap<String, SExpression>();
        this.outputs = new ArrayList<SOperation>();
    }

    @Override
    public String getConnectorId() {
        return this.connectorId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ConnectorEvent getActivationEvent() {
        return this.activationEvent;
    }

    @Override
    public Map<String, SExpression> getInputs() {
        return this.inputs;
    }

    @Override
    public List<SOperation> getOutputs() {
        return this.outputs;
    }

    public void addInput(String key, SExpression value) {
        this.inputs.put(key, value);
    }

    public void addOutput(SOperation operation) {
        this.outputs.add(operation);
    }

    public void setFailAction(FailAction failAction) {
        this.failAction = failAction;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public FailAction getFailAction() {
        return this.failAction;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }
}

