/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.data.instance.api.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.SDefinitiveArchiveNotFound;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SCreateDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceReadException;
import org.bonitasoft.engine.data.instance.exception.SDeleteDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SUpdateDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.SDataInstanceVisibilityMapping;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstance;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstanceVisibilityMapping;
import org.bonitasoft.engine.data.instance.model.archive.builder.SADataInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.model.archive.builder.SADataInstanceVisibilityMappingBuilderFactory;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceVisibilityMappingBuilderFactory;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class DataInstanceServiceImpl
implements DataInstanceService {
    private static final String DATA_INSTANCE = "DATA_INSTANCE";
    protected final Recorder recorder;
    protected final ReadPersistenceService persistenceService;
    protected final ArchiveService archiveService;
    protected final TechnicalLoggerService logger;

    public DataInstanceServiceImpl(Recorder recorder, ReadPersistenceService persistenceService, ArchiveService archiveService, TechnicalLoggerService logger) {
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.archiveService = archiveService;
        this.logger = logger;
    }

    private void archiveDataInstance(SDataInstance sDataInstance) throws SDataInstanceException {
        this.archiveDataInstance(sDataInstance, System.currentTimeMillis());
    }

    private void archiveDataInstance(SDataInstance sDataInstance, long archiveDate) throws SDataInstanceException {
        if (!sDataInstance.isTransientData().booleanValue()) {
            try {
                SADataInstance saDataInstance = BuilderFactory.get(SADataInstanceBuilderFactory.class).createNewInstance(sDataInstance).done();
                ArchiveInsertRecord archiveInsertRecord = new ArchiveInsertRecord(saDataInstance);
                this.archiveService.recordInsert(archiveDate, archiveInsertRecord);
            }
            catch (SDefinitiveArchiveNotFound e) {
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "updateDataInstance", e);
                throw new SDataInstanceException("Unable to create SADataInstance", e);
            }
            catch (SRecorderException e) {
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "updateDataInstance", e);
                throw new SDataInstanceException("Unable to create SADataInstance", e);
            }
        }
    }

    @Override
    public void archiveLocalDataInstancesFromProcessInstance(long processInstanceId, long archiveDate) throws SDataInstanceException {
        int archiveBatchSize = 50;
        int currentIndex = 0;
        List<SDataInstance> sDataInstances = this.getLocalDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString(), currentIndex, 50);
        while (sDataInstances != null && sDataInstances.size() > 0) {
            for (SDataInstance sDataInstance : sDataInstances) {
                this.archiveDataInstance(sDataInstance, archiveDate);
            }
            sDataInstances = this.getLocalDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString(), currentIndex += 50, 50);
        }
    }

    @Override
    public SDataInstance getDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataName, containerType);
        try {
            long dataInstanceId = this.getDataInstanceDataVisibilityMapping(dataName, containerId, containerType);
            return this.getDataInstance(dataInstanceId);
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("No data found with name " + dataName + "  neither on container " + containerId + " with type " + containerType + " nor in its parents", e);
        }
    }

    private long getDataInstanceDataVisibilityMapping(String dataName, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataName", dataName);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getDataInstanceIdFromMapping", parameters, SDataInstanceVisibilityMapping.class);
        Long dataInstanceId = (Long)this.persistenceService.selectOne(selectOneDescriptor);
        if (dataInstanceId == null) {
            StringBuilder stb = new StringBuilder("DataInstance with name not found from mapping: [name: ");
            stb.append(dataName).append(", container type: ").append(containerType);
            stb.append(", container id: ").append(containerId).append(']');
            throw new SBonitaReadException(stb.toString(), null, selectOneDescriptor);
        }
        return dataInstanceId;
    }

    private List<Long> getDataInstanceDataVisibilityMapping(List<String> dataNames, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataNames", dataNames);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getDataInstanceIdsFromMapping", parameters, SDataInstanceVisibilityMapping.class, new QueryOptions(0, dataNames.size()));
        return this.persistenceService.selectList(selectListDescriptor);
    }

    protected long getSADataInstanceDataVisibilityMapping(String dataName, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataName", dataName);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getSADataInstanceIdFromMapping", parameters, SADataInstanceVisibilityMapping.class);
        Long dataInstanceId = (Long)this.persistenceService.selectOne(selectOneDescriptor);
        if (dataInstanceId == null) {
            StringBuilder stb = new StringBuilder("DataInstance with name not found from mapping: [name: ");
            stb.append(dataName).append(", container type: ").append(containerType);
            stb.append(", container id: ").append(containerId).append(']');
            throw new SBonitaReadException(stb.toString(), null, selectOneDescriptor);
        }
        return dataInstanceId;
    }

    protected List<Long> getSADataInstanceDataVisibilityMapping(List<String> dataNames, long containerId, String containerType) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("dataNames", dataNames);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getSADataInstanceIdsFromMapping", parameters, SADataInstanceVisibilityMapping.class, new QueryOptions(0, dataNames.size()));
        return this.persistenceService.selectList(selectListDescriptor);
    }

    @Override
    public List<SDataInstance> getDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(containerType);
        try {
            List<SDataInstanceVisibilityMapping> mappings = this.getDataInstanceVisibilityMappings(containerId, containerType, fromIndex, numberOfResults);
            ArrayList<SDataInstance> dataInstances = new ArrayList<SDataInstance>(mappings.size());
            for (SDataInstanceVisibilityMapping mapping : mappings) {
                dataInstances.add(this.getDataInstance(mapping.getDataInstanceId()));
            }
            return dataInstances;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to read data mappings of the container with type " + containerType + " and id " + containerId, e);
        }
    }

    protected List<SDataInstanceVisibilityMapping> getDataInstanceVisibilityMappings(long containerId, String containerType, int fromIndex, int numberOfResults) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getDataInstanceVisibilityMappings", parameters, SDataInstanceVisibilityMapping.class, new QueryOptions(fromIndex, numberOfResults));
        return this.persistenceService.selectList(selectDescriptor);
    }

    @Override
    public SDataInstance getLocalDataInstance(String dataName, long containerId, String containerType) throws SDataInstanceReadException {
        NullCheckingUtil.checkArgsNotNull(dataName, containerType);
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        Map<String, Object> paraMap = CollectionUtil.buildSimpleMap(fact.getNameKey(), dataName);
        paraMap.put(fact.getContainerIdKey(), containerId);
        paraMap.put(fact.getContainerTypeKey(), containerType);
        try {
            SDataInstance dataInstance = this.persistenceService.selectOne(new SelectOneDescriptor<SDataInstance>("getDataInstancesByNameAndContainer", paraMap, SDataInstance.class, SDataInstance.class));
            if (dataInstance == null) {
                throw new SDataInstanceReadException("No data instance found");
            }
            return dataInstance;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to check if a data instance already exists: " + e.getMessage(), e);
        }
    }

    @Override
    public List<SDataInstance> getLocalDataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceReadException {
        NullCheckingUtil.checkArgsNotNull(containerType);
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        Map<String, Object> paraMap = CollectionUtil.buildSimpleMap(fact.getContainerIdKey(), containerId);
        OrderByOption orderByOption = new OrderByOption(SDataInstance.class, fact.getIdKey(), OrderByType.ASC);
        paraMap.put(fact.getContainerTypeKey(), containerType);
        try {
            return this.persistenceService.selectList(new SelectListDescriptor<SDataInstance>("getDataInstancesByContainer", paraMap, SDataInstance.class, SDataInstance.class, new QueryOptions(fromIndex, numberOfResults, Arrays.asList(orderByOption))));
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Unable to check if a data instance already exists for the data container of type " + containerType + " with id " + containerId + " for reason: " + e.getMessage(), e);
        }
    }

    @Override
    public void addChildContainer(long parentContainerId, String parentContainerType, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "addChildContainer");
        try {
            List<SDataInstanceVisibilityMapping> mappings = this.insertMappingForLocalElement(containerId, containerType);
            ArrayList<String> localData = new ArrayList<String>(mappings.size());
            for (SDataInstanceVisibilityMapping sDataInstanceVisibilityMapping : mappings) {
                localData.add(sDataInstanceVisibilityMapping.getDataName());
            }
            long archivedDate = System.currentTimeMillis();
            int batchSize = 80;
            int currentIndex = 0;
            List<SDataInstance> parentVisibleDataInstances = this.getDataInstances(parentContainerId, parentContainerType, currentIndex, 80);
            while (parentVisibleDataInstances.size() > 0) {
                for (SDataInstance parentData : parentVisibleDataInstances) {
                    if (localData.contains(parentData.getName())) continue;
                    this.insertDataInstanceVisibilityMapping(containerId, containerType, parentData.getName(), parentData.getId(), archivedDate);
                }
                parentVisibleDataInstances = this.getDataInstances(parentContainerId, parentContainerType, currentIndex += 80, 80);
            }
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "addChildContainer");
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "addChildContainer", e);
            throw new SDataInstanceException(e);
        }
        catch (SDefinitiveArchiveNotFound e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "addChildContainer", e);
            throw new SDataInstanceException(e);
        }
    }

    @Override
    public void removeContainer(long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "removeContainer");
        try {
            List<SDataInstanceVisibilityMapping> visibilityMappings;
            do {
                visibilityMappings = this.getDataInstanceVisibilityMappings(containerId, containerType, 0, 100);
                for (SDataInstanceVisibilityMapping sDataInstanceVisibilityMapping : visibilityMappings) {
                    this.deleteDataInstanceVisibilityMapping(sDataInstanceVisibilityMapping);
                }
            } while (visibilityMappings.size() > 0);
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "removeContainer");
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "removeContainer", e);
            throw new SDataInstanceReadException(e);
        }
    }

    private void deleteDataInstanceVisibilityMapping(SDataInstanceVisibilityMapping sDataInstanceVisibilityMapping) throws SDataInstanceException {
        DeleteRecord record = new DeleteRecord(sDataInstanceVisibilityMapping);
        SDeleteEvent deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("DATA_VISIBILITY_MAPPING").done();
        try {
            this.recorder.recordDelete(record, deleteEvent);
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "deleteDataInstanceVisibilityMapping", e);
            throw new SDataInstanceException(e);
        }
    }

    @Override
    public List<SDataInstanceVisibilityMapping> createDataContainer(long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "createDataContainer");
        try {
            List<SDataInstanceVisibilityMapping> listSDataInstanceVisibilityMapping = this.insertMappingForLocalElement(containerId, containerType);
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "createDataContainer");
            return listSDataInstanceVisibilityMapping;
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "createDataContainer", e);
            throw new SDataInstanceException(e);
        }
        catch (SDefinitiveArchiveNotFound e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "createDataContainer", e);
            throw new SDataInstanceException(e);
        }
    }

    protected List<SDataInstanceVisibilityMapping> insertMappingForLocalElement(long containerId, String containerType) throws SRecorderException, SDataInstanceException, SDefinitiveArchiveNotFound {
        int batchSize = 50;
        int currentIndex = 0;
        long archiveDate = System.currentTimeMillis();
        List<SDataInstance> localDataInstances = this.getLocalDataInstances(containerId, containerType, 0, 50);
        ArrayList<SDataInstanceVisibilityMapping> mappings = new ArrayList<SDataInstanceVisibilityMapping>(localDataInstances.size());
        while (localDataInstances != null && localDataInstances.size() > 0) {
            for (SDataInstance sDataInstance : localDataInstances) {
                mappings.add(this.insertDataInstanceVisibilityMapping(containerId, containerType, sDataInstance.getName(), sDataInstance.getId(), archiveDate));
            }
            localDataInstances = this.getLocalDataInstances(containerId, containerType, currentIndex += 50, 50);
        }
        return mappings;
    }

    protected SDataInstanceVisibilityMapping insertDataInstanceVisibilityMapping(long containerId, String containerType, String dataName, long dataInstanceId, long archiveDate) throws SRecorderException, SDefinitiveArchiveNotFound {
        SDataInstanceVisibilityMapping mapping = this.createDataInstanceVisibilityMapping(containerId, containerType, dataName, dataInstanceId);
        InsertRecord record = new InsertRecord(mapping);
        SInsertEvent insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("DATA_VISIBILITY_MAPPING").done();
        this.recorder.recordInsert(record, insertEvent);
        SADataInstanceVisibilityMapping archivedMapping = BuilderFactory.get(SADataInstanceVisibilityMappingBuilderFactory.class).createNewInstance(containerId, containerType, dataName, dataInstanceId, mapping.getId()).done();
        this.archiveService.recordInsert(archiveDate, new ArchiveInsertRecord(archivedMapping));
        return mapping;
    }

    protected SDataInstanceVisibilityMapping createDataInstanceVisibilityMapping(long containerId, String containerType, String dataName, long dataInstanceId) {
        return BuilderFactory.get(SDataInstanceVisibilityMappingBuilderFactory.class).createNewInstance(containerId, containerType, dataName, dataInstanceId).done();
    }

    @Override
    public SADataInstance getSADataInstance(long containerId, String containerType, String dataName, long time) throws SDataInstanceReadException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
        try {
            long dataInstanceId = this.getSADataInstanceDataVisibilityMapping(dataName, containerId, containerType);
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceId", dataInstanceId);
            parameters.put("time", time);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getSADataInstanceByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstance", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getSADataInstance(long sourceObjectId, long time) throws SDataInstanceReadException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceId", sourceObjectId);
            parameters.put("time", time);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getSADataInstanceByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstance", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getLastSADataInstance(long dataInstanceId) throws SDataInstanceReadException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put("dataInstanceId", dataInstanceId);
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getLastSADataInstanceByDataInstanceId", parameters, SADataInstance.class));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public SADataInstance getLastSADataInstance(String dataName, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
        ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("dataName", dataName);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        try {
            SADataInstance saDataInstance = (SADataInstance)readPersistenceService.selectOne(new SelectOneDescriptor("getLastSADataInstanceByContainer", parameters, SADataInstance.class));
            if (saDataInstance == null) {
                SDataInstanceNotFoundException exception = new SDataInstanceNotFoundException("No archived data instance found for data:" + dataName + " in container: " + containerType + " " + containerId);
                this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance", exception);
                throw exception;
            }
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance");
            return saDataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastSADataInstance", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public List<SADataInstance> getLastLocalSADataInstances(long containerId, String containerType, int startIndex, int maxResults) throws SDataInstanceReadException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLastLocalSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("containerId", containerId);
            parameters.put("containerType", containerType);
            List<SADataInstance> saDataInstances = readPersistenceService.selectList(new SelectListDescriptor("getLastLocalSADataInstances", parameters, SADataInstance.class, new QueryOptions(startIndex, maxResults)));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLastLocalSADataInstances");
            return saDataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLastLocalSADataInstances", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public long getNumberOfDataInstances(long containerId, DataInstanceContainer containerType) throws SDataInstanceReadException {
        Long dataInstanceId;
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getNumberOfDataInstances");
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType.toString());
        SelectOneDescriptor selectOneDescriptor = new SelectOneDescriptor("getNumberOfDataInstancesForContainer", parameters, SDataInstanceVisibilityMapping.class);
        try {
            dataInstanceId = (Long)this.persistenceService.selectOne(selectOneDescriptor);
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getNumberOfDataInstances", e);
            throw new SDataInstanceReadException(e);
        }
        this.logAfterMethod(TechnicalLogSeverity.TRACE, "getNumberOfDataInstances");
        return dataInstanceId;
    }

    @Override
    public List<SDataInstance> getDataInstances(List<String> dataNames, long containerId, String containerType) throws SDataInstanceException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getDataInstances");
        NullCheckingUtil.checkArgsNotNull(dataNames, containerType);
        if (dataNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<Long> dataInstanceIds = this.getDataInstanceDataVisibilityMapping(dataNames, containerId, containerType);
            ArrayList<SDataInstance> finalResult = new ArrayList<SDataInstance>(dataNames.size());
            finalResult.addAll(this.getDataInstances(dataInstanceIds));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getDataInstances");
            return finalResult;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getDataInstances", e);
            throw new SDataInstanceReadException("Unable to find the data in the data mapping with name = " + dataNames + ", containerId = " + containerId + ", containerType = " + containerType, e);
        }
    }

    @Override
    public List<SADataInstance> getSADataInstances(long containerId, String containerType, List<String> dataNames, long time) throws SDataInstanceReadException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getSADataInstances");
        if (dataNames.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            List<Long> dataInstanceIds = this.getSADataInstanceDataVisibilityMapping(dataNames, containerId, containerType);
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("dataInstanceIds", dataInstanceIds);
            parameters.put("time", time);
            List<SADataInstance> listSADataInstance = readPersistenceService.selectList(new SelectListDescriptor("getSADataInstancesByDataInstanceIdAndArchiveDate", parameters, SADataInstance.class, new QueryOptions(0, dataInstanceIds.size())));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getSADataInstances");
            return listSADataInstance;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getSADataInstances", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    @Override
    public List<SADataInstance> getLocalSADataInstances(long containerId, String containerType, int fromIndex, int numberOfResults) throws SDataInstanceReadException {
        this.logBeforeMethod(TechnicalLogSeverity.TRACE, "getLocalSADataInstances");
        try {
            ReadPersistenceService readPersistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("containerId", containerId);
            parameters.put("containerType", containerType);
            List<SADataInstance> saDataInstances = readPersistenceService.selectList(new SelectListDescriptor("getLocalSADataInstances", parameters, SADataInstance.class, new QueryOptions(fromIndex, numberOfResults)));
            this.logAfterMethod(TechnicalLogSeverity.TRACE, "getLocalSADataInstances");
            return saDataInstances;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "getLocalSADataInstances", e);
            throw new SDataInstanceReadException("Unable to read SADataInstance", e);
        }
    }

    private void deleteSADataInstance(SADataInstance dataInstance) throws SDeleteDataInstanceException {
        DeleteRecord deleteRecord = new DeleteRecord(dataInstance);
        SEvent event = BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent(DATA_INSTANCE).setObject(dataInstance).done();
        SDeleteEvent deleteEvent = (SDeleteEvent)event;
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDeleteDataInstanceException("Impossible to delete data instance", e);
        }
    }

    @Override
    public void deleteLocalArchivedDataInstances(long containerId, String containerType) throws SDataInstanceException {
        List<SADataInstance> sDataInstances;
        do {
            sDataInstances = this.getLocalSADataInstances(containerId, containerType, 0, 100);
            for (SADataInstance sDataInstance : sDataInstances) {
                this.deleteSADataInstance(sDataInstance);
            }
        } while (!sDataInstances.isEmpty());
        this.deleteArchivedContainer(containerId, containerType);
    }

    private void deleteArchivedContainer(long containerId, String containerType) throws SDataInstanceException {
        try {
            List<SADataInstanceVisibilityMapping> visibilityMappings;
            do {
                visibilityMappings = this.getSADataInstanceVisibilityMappings(containerId, containerType, 0, 100);
                for (SADataInstanceVisibilityMapping sDataInstanceVisibilityMapping : visibilityMappings) {
                    this.deleteSADataInstanceVisibilityMapping(sDataInstanceVisibilityMapping);
                }
            } while (visibilityMappings.size() > 0);
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException(e);
        }
    }

    private void deleteSADataInstanceVisibilityMapping(SADataInstanceVisibilityMapping sDataInstanceVisibilityMapping) throws SDataInstanceException {
        DeleteRecord record = new DeleteRecord(sDataInstanceVisibilityMapping);
        SDeleteEvent deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("DATA_VISIBILITY_MAPPING").done();
        try {
            this.recorder.recordDelete(record, deleteEvent);
        }
        catch (SRecorderException e) {
            this.logOnExceptionMethod(TechnicalLogSeverity.TRACE, "deleteSADataInstanceVisibilityMapping", e);
            throw new SDataInstanceException(e);
        }
    }

    protected List<SADataInstanceVisibilityMapping> getSADataInstanceVisibilityMappings(long containerId, String containerType, int fromIndex, int numberOfResults) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("containerId", containerId);
        parameters.put("containerType", containerType);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getSADataInstanceVisibilityMappings", parameters, SADataInstanceVisibilityMapping.class, new QueryOptions(fromIndex, numberOfResults));
        return this.persistenceService.selectList(selectDescriptor);
    }

    @Override
    public void deleteLocalDataInstances(long containerId, String dataInstanceContainerType, boolean dataPresent) throws SDataInstanceException {
        if (dataPresent) {
            int deleteBatchSize = 80;
            List<SDataInstance> sDataInstances = this.getLocalDataInstances(containerId, dataInstanceContainerType, 0, 80);
            while (sDataInstances.size() > 0) {
                for (SDataInstance sDataInstance : sDataInstances) {
                    this.deleteDataInstance(sDataInstance);
                }
                sDataInstances = this.getLocalDataInstances(containerId, dataInstanceContainerType, 0, 80);
            }
        }
        this.removeContainer(containerId, dataInstanceContainerType);
    }

    private void logBeforeMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(TechnicalLogSeverity technicalLogSeverity, String methodName) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogAfterMethod(this.getClass(), methodName));
        }
    }

    private void logOnExceptionMethod(TechnicalLogSeverity technicalLogSeverity, String methodName, Exception e) {
        if (this.logger.isLoggable(this.getClass(), technicalLogSeverity)) {
            this.logger.log(this.getClass(), technicalLogSeverity, LogUtil.getLogOnExceptionMethod(this.getClass(), methodName, e));
        }
    }

    private SInsertEvent getInsertEvent(Object obj) {
        return (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent(DATA_INSTANCE).setObject(obj).done();
    }

    private SUpdateEvent getUpdateEvent(Object obj) {
        return (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(DATA_INSTANCE).setObject(obj).done();
    }

    private SDeleteEvent getDeleteEvent(Object obj) {
        return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent(DATA_INSTANCE).setObject(obj).done();
    }

    @Override
    public void createDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        try {
            InsertRecord insertRecord = new InsertRecord(dataInstance);
            SInsertEvent insertEvent = this.getInsertEvent(dataInstance);
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SCreateDataInstanceException("Impossible to create data instance.", e);
        }
        this.archiveDataInstance(dataInstance);
    }

    @Override
    public void updateDataInstance(SDataInstance dataInstance, EntityUpdateDescriptor descriptor) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)dataInstance, descriptor);
        SUpdateEvent updateEvent = this.getUpdateEvent(dataInstance);
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SUpdateDataInstanceException("Impossible to update data instance '" + dataInstance.getName() + "': " + e.getMessage(), e);
        }
        this.archiveDataInstance(dataInstance);
    }

    @Override
    public void deleteDataInstance(SDataInstance dataInstance) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstance);
        DeleteRecord deleteRecord = new DeleteRecord(dataInstance);
        SDeleteEvent deleteEvent = this.getDeleteEvent(dataInstance);
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SDeleteDataInstanceException("Impossible to delete data instance", e);
        }
    }

    @Override
    public SDataInstance getDataInstance(long dataInstanceId) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstanceId);
        try {
            SelectByIdDescriptor<SDataInstance> selectDescriptor = new SelectByIdDescriptor<SDataInstance>("getDataInstanceById", SDataInstance.class, dataInstanceId);
            SDataInstance dataInstance = this.persistenceService.selectById(selectDescriptor);
            if (dataInstance == null) {
                throw new SDataInstanceNotFoundException("Cannot get the data instance with id " + dataInstanceId);
            }
            return dataInstance;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Cannot get the data instance with id " + dataInstanceId, e);
        }
    }

    private List<SDataInstance> getDataInstances(List<Long> dataInstanceIds) throws SDataInstanceException {
        NullCheckingUtil.checkArgsNotNull(dataInstanceIds);
        if (dataInstanceIds.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> parameters = CollectionUtil.buildSimpleMap("ids", dataInstanceIds);
            SelectListDescriptor selectDescriptor = new SelectListDescriptor("getDataInstanceByIds", parameters, SDataInstance.class, new QueryOptions(0, dataInstanceIds.size()));
            List<SDataInstance> dataInstances = this.persistenceService.selectList(selectDescriptor);
            if (dataInstances == null) {
                throw new SDataInstanceNotFoundException("Cannot get the data instance with id " + dataInstanceIds);
            }
            return dataInstances;
        }
        catch (SBonitaReadException e) {
            throw new SDataInstanceReadException("Cannot get the data instance with id " + dataInstanceIds, e);
        }
    }
}

