/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SFlowNodeInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SUserTaskInstanceBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.search.FilterOperationType;

public abstract class AbstractProcessInstanceInterruptor {
    private final TechnicalLoggerService logger;

    public AbstractProcessInstanceInterruptor(TechnicalLoggerService technicalLoggerService) {
        this.logger = technicalLoggerService;
    }

    public void interruptProcessInstance(long processInstanceId, SStateCategory stateCategory, long userId) throws SProcessInstanceNotFoundException, SBonitaException {
        this.setProcessStateCategory(processInstanceId, stateCategory);
        List<Long> stableChildrenIds = this.interruptChildrenFlowNodeInstances(processInstanceId, stateCategory);
        if (stableChildrenIds != null) {
            for (Long childId : stableChildrenIds) {
                this.resumeChildExecution(childId, processInstanceId, userId);
            }
        }
    }

    public void interruptProcessInstance(long processInstanceId, SStateCategory stateCategory, long userId, long exceptionChildId) throws SProcessInstanceNotFoundException, SBonitaException {
        this.setProcessStateCategory(processInstanceId, stateCategory);
        List<Long> stableChildrenIds = this.interruptChildrenFlowNodeInstances(processInstanceId, stateCategory, exceptionChildId);
        if (stableChildrenIds != null) {
            for (Long childId : stableChildrenIds) {
                this.resumeChildExecution(childId, processInstanceId, userId);
            }
        }
    }

    public void interruptChildrenOnly(long processInstanceId, SStateCategory stateCategory, long userId, long interruptorChildId) throws SBonitaException {
        List<Long> stableChildrenIds = this.interruptChildrenFlowNodeInstances(processInstanceId, stateCategory, interruptorChildId);
        if (stableChildrenIds != null) {
            for (Long childId : stableChildrenIds) {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Resume child in stateCategory " + (Object)((Object)stateCategory) + " id = " + childId);
                }
                this.resumeChildExecution(childId, processInstanceId, userId);
            }
        }
    }

    protected abstract void setProcessStateCategory(long var1, SStateCategory var3) throws SProcessInstanceNotFoundException, SBonitaException;

    protected abstract void resumeChildExecution(long var1, long var3, long var5) throws SBonitaException;

    private List<Long> interruptChildrenFlowNodeInstances(long processInstanceId, SStateCategory stateCategory) throws SBonitaException {
        List<SFlowNodeInstance> children;
        ArrayList<Long> allChildrenToResume = new ArrayList<Long>();
        long count = 0L;
        do {
            children = this.getChildren(processInstanceId);
            count = this.getNumberOfChildren(processInstanceId);
            List<Long> childrenToResume = this.interruptFlowNodeInstances(children, stateCategory);
            allChildrenToResume.addAll(childrenToResume);
        } while (count > (long)children.size());
        return allChildrenToResume;
    }

    private List<Long> interruptChildrenFlowNodeInstances(long processInstanceId, SStateCategory stateCategory, long exceptionChildId) throws SBonitaException {
        List<SFlowNodeInstance> children;
        ArrayList<Long> allChildrenToResume = new ArrayList<Long>();
        long count = 0L;
        do {
            children = this.getChildrenExcept(processInstanceId, exceptionChildId);
            count = this.getNumberOfChildrenExcept(processInstanceId, exceptionChildId);
            List<Long> childrenToResume = this.interruptFlowNodeInstances(children, stateCategory);
            allChildrenToResume.addAll(childrenToResume);
        } while (count > (long)children.size());
        return allChildrenToResume;
    }

    protected abstract List<SFlowNodeInstance> getChildren(long var1) throws SBonitaException;

    protected abstract long getNumberOfChildren(long var1) throws SBonitaSearchException;

    protected abstract List<SFlowNodeInstance> getChildrenExcept(long var1, long var3) throws SBonitaException;

    protected abstract long getNumberOfChildrenExcept(long var1, long var3) throws SBonitaSearchException;

    private List<Long> interruptFlowNodeInstances(List<SFlowNodeInstance> children, SStateCategory stateCategory) throws SBonitaException {
        ArrayList<Long> childrenToResume = new ArrayList<Long>();
        for (SFlowNodeInstance child : children) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Put element in " + (Object)((Object)stateCategory) + ", id= " + child.getId() + " name = " + child.getName() + " state = " + child.getStateName());
            }
            this.setChildStateCategory(child.getId(), stateCategory);
            if (!child.mustExecuteOnAbortOrCancelProcess()) continue;
            childrenToResume.add(child.getId());
        }
        return childrenToResume;
    }

    protected abstract void setChildStateCategory(long var1, SStateCategory var3) throws SBonitaException;

    protected QueryOptions getQueryOptions(long processInstanceId) {
        int numberOfResults = 100;
        ArrayList<OrderByOption> orderByOptions = new ArrayList<OrderByOption>(1);
        orderByOptions.add(new OrderByOption(SFlowNodeInstance.class, BuilderFactory.get(SUserTaskInstanceBuilderFactory.class).getNameKey(), OrderByType.ASC));
        List<FilterOption> filterOptions = this.getFilterOptions(processInstanceId);
        return new QueryOptions(0, 100, orderByOptions, filterOptions, null);
    }

    protected QueryOptions getQueryOptions(long processInstanceId, long childExceptionId) {
        int numberOfResults = 100;
        ArrayList<OrderByOption> orderByOptions = new ArrayList<OrderByOption>(1);
        orderByOptions.add(new OrderByOption(SFlowNodeInstance.class, BuilderFactory.get(SUserTaskInstanceBuilderFactory.class).getNameKey(), OrderByType.ASC));
        List<FilterOption> filterOptions = this.getFilterOptions(processInstanceId, childExceptionId);
        return new QueryOptions(0, 100, orderByOptions, filterOptions, null);
    }

    protected List<FilterOption> getFilterOptions(long processInstanceId) {
        SFlowNodeInstanceBuilderFactory flowNodeInstanceKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>(3);
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getParentProcessInstanceKey(), processInstanceId));
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getTerminalKey(), false));
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getStateCategoryKey(), SStateCategory.NORMAL.name()));
        return filterOptions;
    }

    protected List<FilterOption> getFilterOptions(long processInstanceId, long childExceptionId) {
        SFlowNodeInstanceBuilderFactory flowNodeInstanceKeyProvider = BuilderFactory.get(SUserTaskInstanceBuilderFactory.class);
        ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>(3);
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getParentProcessInstanceKey(), processInstanceId));
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getTerminalKey(), false));
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getStateCategoryKey(), SStateCategory.NORMAL.name()));
        filterOptions.add(new FilterOption(SFlowNodeInstance.class, flowNodeInstanceKeyProvider.getIdKey(), (Object)childExceptionId, FilterOperationType.DIFFERENT));
        return filterOptions;
    }
}

