/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.execution.StateBehaviors;
import org.bonitasoft.engine.execution.state.FlowNodeStateWithConnectors;

public class ExecutingAutomaticActivityStateImpl
extends FlowNodeStateWithConnectors {
    private final StateBehaviors stateBehaviors;

    public ExecutingAutomaticActivityStateImpl(StateBehaviors stateBehaviors) {
        super(stateBehaviors, true, true);
        this.stateBehaviors = stateBehaviors;
    }

    @Override
    protected void afterOnFinish(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        this.stateBehaviors.mapDataOutputOfMultiInstance(processDefinition, flowNodeInstance);
        this.stateBehaviors.updateDisplayDescriptionAfterCompletion(processDefinition, flowNodeInstance);
    }

    @Override
    protected void onEnterToOnFinish(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        SActivityInstance activityInstance = (SActivityInstance)flowNodeInstance;
        this.stateBehaviors.updateDisplayNameAndDescription(processDefinition, flowNodeInstance);
        this.stateBehaviors.handleCallActivity(processDefinition, flowNodeInstance);
        this.stateBehaviors.executeOperations(processDefinition, activityInstance);
        this.stateBehaviors.handleThrowEvent(processDefinition, flowNodeInstance);
    }

    @Override
    protected void beforeOnEnter(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        this.stateBehaviors.createData(processDefinition, flowNodeInstance);
        this.stateBehaviors.createAttachedBoundaryEvents(processDefinition, (SActivityInstance)flowNodeInstance);
    }

    @Override
    public int getId() {
        return 37;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "executing";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance parentInstance, SFlowNodeInstance childInstance) {
        return false;
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return true;
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

