/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.api.impl.transaction.event.CreateEventInstance;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.exception.SConnectorDefinitionNotFoundException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SEndEventDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowErrorEventTriggerDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerType;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SEndEventInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SEndEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.execution.archive.ProcessArchiver;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.execution.work.ExecuteConnectorWork;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.STransactionException;
import org.bonitasoft.engine.work.BonitaWork;
import org.bonitasoft.engine.work.WorkService;

public class ExecuteConnectorOfActivity
extends ExecuteConnectorWork {
    private static final long serialVersionUID = 6220793197069669088L;
    private final long flowNodeInstanceId;
    private final long flowNodeDefinitionId;

    ExecuteConnectorOfActivity(long processDefinitionId, long flowNodeDefinitionId, long flowNodeInstanceId, long connectorInstanceId, String connectorDefinitionName) {
        super(processDefinitionId, connectorInstanceId, connectorDefinitionName, new SExpressionContext((Long)flowNodeInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinitionId));
        this.flowNodeDefinitionId = flowNodeDefinitionId;
        this.flowNodeInstanceId = flowNodeInstanceId;
    }

    @Override
    protected void evaluateOutput(Map<String, Object> context, ConnectorResult result, SConnectorDefinition sConnectorDefinition) throws STransactionException, SBonitaException {
        this.evaluateOutput(context, result, sConnectorDefinition, this.flowNodeInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name());
    }

    @Override
    protected void continueFlow(Map<String, Object> context) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        WorkService workService = tenantAccessor.getWorkService();
        SFlowNodeInstance sFlowNodeInstance = activityInstanceService.getFlowNodeInstance(this.flowNodeInstanceId);
        long parentProcessInstanceId = sFlowNodeInstance.getParentProcessInstanceId();
        BonitaWork executeFlowNodeWork = WorkFactory.createExecuteFlowNodeWork(sFlowNodeInstance.getProcessDefinitionId(), parentProcessInstanceId, this.flowNodeInstanceId, null, null);
        workService.registerWork(executeFlowNodeWork);
    }

    @Override
    protected void setContainerInFail(Map<String, Object> context) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        ConnectorInstanceService connectorInstanceService = tenantAccessor.getConnectorInstanceService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ArchiveService archiveService = tenantAccessor.getArchiveService();
        FlowNodeStateManager flowNodeStateManager = tenantAccessor.getFlowNodeStateManager();
        DataInstanceService dataInstanceService = tenantAccessor.getDataInstanceService();
        SFlowNodeInstance intTxflowNodeInstance = activityInstanceService.getFlowNodeInstance(this.flowNodeInstanceId);
        ProcessArchiver.archiveFlowNodeInstance(intTxflowNodeInstance, false, this.processDefinitionId, processInstanceService, processDefinitionService, archiveService, dataInstanceService, activityInstanceService, connectorInstanceService);
        activityInstanceService.setState(intTxflowNodeInstance, flowNodeStateManager.getFailedState());
    }

    @Override
    protected SThrowEventInstance createThrowErrorEventInstance(Map<String, Object> context, SEndEventDefinition eventDefinition) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        EventInstanceService eventInstanceService = tenantAccessor.getEventInstanceService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SFlowNodeInstance sFlowNodeInstance = activityInstanceService.getFlowNodeInstance(this.flowNodeInstanceId);
        SEndEventInstanceBuilder builder = BuilderFactory.get(SEndEventInstanceBuilderFactory.class).createNewEndEventInstance(eventDefinition.getName(), eventDefinition.getId(), sFlowNodeInstance.getRootContainerId(), sFlowNodeInstance.getParentContainerId(), this.processDefinitionId, sFlowNodeInstance.getRootContainerId(), sFlowNodeInstance.getParentContainerId());
        builder.setParentActivityInstanceId(this.flowNodeInstanceId);
        SThrowEventInstance done = (SThrowEventInstance)builder.done();
        new CreateEventInstance(done, eventInstanceService).call();
        return done;
    }

    @Override
    protected void errorEventOnFail(Map<String, Object> context, SConnectorDefinition sConnectorDefinition, Exception exception) throws SBonitaException {
        this.setConnectorOnlyToFailed(context, exception);
        this.handleErrorEventOnFail(context, sConnectorDefinition, exception);
    }

    private void handleErrorEventOnFail(Map<String, Object> context, SConnectorDefinition sConnectorDefinition, Exception exception) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ActivityInstanceService activityInstanceService = tenantAccessor.getActivityInstanceService();
        SFlowNodeInstance sFlowNodeInstance = activityInstanceService.getFlowNodeInstance(this.flowNodeInstanceId);
        String errorCode = sConnectorDefinition.getErrorCode();
        SThrowErrorEventTriggerDefinition errorEventTriggerDefinition = BuilderFactory.get(SThrowErrorEventTriggerDefinitionBuilderFactory.class).createNewInstance(errorCode).done();
        SEndEventDefinition eventDefinition = BuilderFactory.get(SEndEventDefinitionBuilderFactory.class).createNewInstance(errorCode).addErrorEventTriggerDefinition(errorEventTriggerDefinition).done();
        SThrowEventInstance throwEventInstance = this.createThrowErrorEventInstance(context, eventDefinition);
        SProcessDefinition sProcessDefinition = processDefinitionService.getProcessDefinition(this.processDefinitionId);
        boolean hasActionToExecute = eventsHandler.getHandler(SEventTriggerType.ERROR).handlePostThrowEvent(sProcessDefinition, eventDefinition, throwEventInstance, errorEventTriggerDefinition, sFlowNodeInstance);
        this.setConnectorAndContainerToFailed(context, exception);
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": flowNodeInstanceId = " + this.flowNodeInstanceId + ", connectorDefinitionName = " + this.connectorDefinitionName;
    }

    @Override
    protected SConnectorDefinition getSConnectorDefinition(ProcessDefinitionService processDefinitionService) throws SBonitaException {
        SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(this.processDefinitionId);
        SFlowNodeDefinition flowNodeDefinition = processDefinition.getProcessContainer().getFlowNode(this.flowNodeDefinitionId);
        SConnectorDefinition sConnectorDefinition = flowNodeDefinition.getConnectorDefinition(this.connectorDefinitionName);
        if (sConnectorDefinition == null) {
            throw new SConnectorDefinitionNotFoundException("Coud'nt find the connector definition [" + this.connectorDefinitionName + "]");
        }
        return sConnectorDefinition;
    }

    @Override
    public String getRecoveryProcedure() {
        return "call processApi.executeFlowNode(" + this.flowNodeInstanceId + ")";
    }
}

