/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.exception.SConnectorDefinitionNotFoundException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SEndEventDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.event.trigger.SThrowErrorEventTriggerDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.event.SEndEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerType;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SThrowErrorEventTriggerDefinition;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.FlowNodeSelector;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.StartFlowNodeFilter;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.work.ExecuteConnectorWork;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class ExecuteConnectorOfProcess
extends ExecuteConnectorWork {
    private static final long serialVersionUID = 4993288070721748951L;
    private final long processInstanceId;
    private final long rootProcessInstanceId;
    private final ConnectorEvent activationEvent;
    private final FlowNodeSelector selectorForConnectorOnEnter;

    ExecuteConnectorOfProcess(long processDefinitionId, long connectorInstanceId, String connectorDefinitionName, long processInstanceId, long rootProcessInstanceId, ConnectorEvent activationEvent, FlowNodeSelector selectorForConnectorOnEnter) {
        super(processDefinitionId, connectorInstanceId, connectorDefinitionName, new SExpressionContext((Long)processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.name(), processDefinitionId));
        this.processInstanceId = processInstanceId;
        this.rootProcessInstanceId = rootProcessInstanceId;
        this.activationEvent = activationEvent;
        this.selectorForConnectorOnEnter = selectorForConnectorOnEnter;
    }

    @Override
    protected void evaluateOutput(Map<String, Object> context, ConnectorResult result, SConnectorDefinition sConnectorDefinition) throws SBonitaException {
        this.evaluateOutput(context, result, sConnectorDefinition, this.processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.name());
    }

    @Override
    protected void continueFlow(Map<String, Object> context) throws SBonitaException {
        SProcessInstance intTxProcessInstance;
        SProcessDefinition sProcessDefinition;
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        ProcessInstanceService processInstanceService = tenantAccessor.getProcessInstanceService();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        boolean connectorTriggered = processExecutor.executeConnectors(sProcessDefinition = processDefinitionService.getProcessDefinition(this.processDefinitionId), intTxProcessInstance = processInstanceService.getProcessInstance(this.processInstanceId), this.activationEvent, this.selectorForConnectorOnEnter);
        if (!connectorTriggered) {
            if (this.activationEvent == ConnectorEvent.ON_ENTER) {
                FlowNodeSelector selector = this.selectorForConnectorOnEnter != null ? this.selectorForConnectorOnEnter : new FlowNodeSelector(sProcessDefinition, new StartFlowNodeFilter());
                processExecutor.startElements(intTxProcessInstance, selector);
            } else {
                processExecutor.handleProcessCompletion(sProcessDefinition, intTxProcessInstance, false);
            }
        }
    }

    @Override
    protected void setContainerInFail(Map<String, Object> context) throws SBonitaException {
        ProcessInstanceService processInstanceService = this.getTenantAccessor(context).getProcessInstanceService();
        SProcessInstance intTxProcessInstance = processInstanceService.getProcessInstance(this.processInstanceId);
        processInstanceService.setState(intTxProcessInstance, ProcessInstanceState.ERROR);
    }

    @Override
    protected SThrowEventInstance createThrowErrorEventInstance(Map<String, Object> context, SEndEventDefinition eventDefinition) throws SBonitaException {
        BPMInstancesCreator bpmInstancesCreator = this.getTenantAccessor(context).getBPMInstancesCreator();
        SFlowNodeInstance createFlowNodeInstance = bpmInstancesCreator.createFlowNodeInstance(this.processDefinitionId, this.rootProcessInstanceId, this.processInstanceId, SFlowElementsContainerType.PROCESS, eventDefinition, this.rootProcessInstanceId, this.processInstanceId, false, -1, SStateCategory.NORMAL, -1L, null);
        return (SThrowEventInstance)createFlowNodeInstance;
    }

    @Override
    protected void errorEventOnFail(Map<String, Object> context, SConnectorDefinition sConnectorDefinition, Exception exception) throws SBonitaException {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        EventsHandler eventsHandler = tenantAccessor.getEventsHandler();
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        this.setConnectorOnlyToFailed(context, exception);
        String errorCode = sConnectorDefinition.getErrorCode();
        SThrowErrorEventTriggerDefinition errorEventTriggerDefinition = BuilderFactory.get(SThrowErrorEventTriggerDefinitionBuilderFactory.class).createNewInstance(errorCode).done();
        SEndEventDefinition eventDefinition = BuilderFactory.get(SEndEventDefinitionBuilderFactory.class).createNewInstance(errorCode).addErrorEventTriggerDefinition(errorEventTriggerDefinition).done();
        SThrowEventInstance throwEventInstance = this.createThrowErrorEventInstance(context, eventDefinition);
        SProcessDefinition sProcessDefinition = processDefinitionService.getProcessDefinition(this.processDefinitionId);
        boolean hasActionToExecute = eventsHandler.getHandler(SEventTriggerType.ERROR).handlePostThrowEvent(sProcessDefinition, eventDefinition, throwEventInstance, errorEventTriggerDefinition, null);
        if (!hasActionToExecute) {
            this.setConnectorAndContainerToFailed(context, exception);
        }
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": processInstanceId = " + this.processInstanceId + ", connectorDefinitionName = " + this.connectorDefinitionName;
    }

    @Override
    protected SConnectorDefinition getSConnectorDefinition(ProcessDefinitionService processDefinitionService) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException, SConnectorDefinitionNotFoundException {
        SProcessDefinition processDefinition = processDefinitionService.getProcessDefinition(this.processDefinitionId);
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SConnectorDefinition sConnectorDefinition = processContainer.getConnectorDefinition(this.connectorDefinitionName);
        if (sConnectorDefinition == null) {
            throw new SConnectorDefinitionNotFoundException(this.connectorDefinitionName);
        }
        return sConnectorDefinition;
    }
}

