/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.Map;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.execution.SIllegalStateTransition;
import org.bonitasoft.engine.execution.work.WrappingBonitaWork;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.incident.Incident;
import org.bonitasoft.engine.incident.IncidentService;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.work.BonitaWork;

public class FailureHandlingBonitaWork
extends WrappingBonitaWork {
    private static final long serialVersionUID = 1L;

    public FailureHandlingBonitaWork(BonitaWork work) {
        super(work);
    }

    protected void logIncident(Exception cause, Exception exceptionWhenHandlingFailure) {
        Incident incident = new Incident(this.getDescription(), this.getRecoveryProcedure(), cause, exceptionWhenHandlingFailure);
        IncidentService incidentService = this.getTenantAccessor().getIncidentService();
        incidentService.report(this.getTenantId(), incident);
    }

    TenantServiceAccessor getTenantAccessor() {
        try {
            return TenantServiceSingleton.getInstance(this.getTenantId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work(Map<String, Object> context) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        SessionAccessor sessionAccessor = tenantAccessor.getSessionAccessor();
        context.put("tenantAccessor", tenantAccessor);
        try {
            sessionAccessor.setTenantId(this.getTenantId());
            if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                loggerService.log(this.getClass(), TechnicalLogSeverity.TRACE, "Starting work: " + this.getDescription());
            }
            this.getWrappedWork().work(context);
        }
        catch (SExpressionEvaluationException e) {
            this.handleFailureWrappedWork(loggerService, e, context);
            this.logException(loggerService, e);
        }
        catch (Exception e) {
            this.handleFailure(e, context);
        }
        finally {
            sessionAccessor.deleteTenantId();
        }
    }

    @Override
    public void handleFailure(Exception e, Map<String, Object> context) {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor();
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        Throwable cause = e.getCause();
        if (this.mustNotPutInFailedState(e)) {
            this.logFailureCause(loggerService, e);
        } else if (this.mustNotPutInFailedState(cause)) {
            this.logFailureCause(loggerService, cause);
        } else {
            if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
                loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "The work [" + this.getDescription() + "] failed. The failure will be handled.");
            }
            this.handleFailureWrappedWork(loggerService, e, context);
            this.logException(loggerService, e);
        }
    }

    private void logException(TechnicalLoggerService loggerService, Throwable e) {
        if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Exception : ", e);
        } else {
            String message = e.getMessage();
            if (message == null || message.isEmpty()) {
                message = "No message";
            }
            loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getClass().getName() + " : \"" + message + "\"");
        }
    }

    private void handleFailureWrappedWork(TechnicalLoggerService loggerService, Exception e, Map<String, Object> context) {
        try {
            this.getWrappedWork().handleFailure(e, context);
        }
        catch (Exception e1) {
            loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unexpected error while executing work [" + this.getDescription() + "]" + ". You may consider restarting the system. This will restart all works.", e);
            loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to handle the failure. ", e1);
            this.logIncident(e, e1);
        }
    }

    private boolean mustNotPutInFailedState(Throwable cause) {
        return cause instanceof SFlowNodeNotFoundException || cause instanceof SProcessInstanceNotFoundException || cause instanceof SProcessDefinitionNotFoundException || this.isTransitionFromTerminalState(cause);
    }

    boolean isTransitionFromTerminalState(Throwable cause) {
        if (!(cause instanceof SIllegalStateTransition)) {
            return false;
        }
        SIllegalStateTransition e = (SIllegalStateTransition)cause;
        return e.isTransitionFromTerminalState();
    }

    protected void logFailureCause(TechnicalLoggerService loggerService, Throwable cause) {
        if (loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            loggerService.log(this.getClass(), TechnicalLogSeverity.DEBUG, "The work [" + this.getDescription() + "] failed to execute due to : ", cause);
        }
    }
}

