/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.Map;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.SExpression;

public class ReturnTypeChecker {
    private static final String CONTAINER_ID = "containerId";
    private static final String CONTAINER_TYPE = "containerType";
    private static final String ACTIVITY_INSTANCE_SCOPE = "ACTIVITY_INSTANCE";
    private static final String PROCESS_INSTANCE_SCOPE = "PROCESS_INSTANCE";

    public void checkReturnType(SExpression expression, Object result, Map<String, Object> context) throws SExpressionEvaluationException {
        if (result != null && !result.getClass().getName().equals(expression.getReturnType())) {
            try {
                try {
                    Class<?> declaredReturnedType = Thread.currentThread().getContextClassLoader().loadClass(expression.getReturnType());
                    Class<?> evaluatedReturnedType = result.getClass();
                    if (!declaredReturnedType.isAssignableFrom(evaluatedReturnedType)) {
                        throw new SExpressionEvaluationException("Declared return type " + declaredReturnedType + " is not compatible with evaluated type " + evaluatedReturnedType + " for expression " + expression.getName(), expression.getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new SExpressionEvaluationException("Declared return type unknown : " + expression.getReturnType() + " for expression " + expression.getName(), e, expression.getName());
                }
            }
            catch (SExpressionEvaluationException e) {
                if (this.isContextOnActivity(context)) {
                    e.setFlowNodeInstanceIdOnContext((Long)context.get(CONTAINER_ID));
                }
                if (this.isContextOnProcess(context)) {
                    e.setProcessInstanceIdOnContext((Long)context.get(CONTAINER_ID));
                }
                throw e;
            }
        }
    }

    protected boolean isContextOnProcess(Map<String, Object> context) {
        return context.containsKey(CONTAINER_TYPE) && PROCESS_INSTANCE_SCOPE.equals(context.get(CONTAINER_TYPE));
    }

    protected boolean isContextOnActivity(Map<String, Object> context) {
        return context.containsKey(CONTAINER_TYPE) && ACTIVITY_INSTANCE_SCOPE.equals(context.get(CONTAINER_TYPE));
    }
}

