/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserCreationException;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.builder.SUserBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserBuilderFactory;
import org.bonitasoft.engine.identity.xml.CustomUserInfoValueImporter;
import org.bonitasoft.engine.identity.xml.ImportOrganizationStrategy;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class UserImporter {
    private final IdentityService identityService;
    private final ImportOrganizationStrategy strategy;
    private final long userIdFromSession;
    private final CustomUserInfoValueImporter infoValueImporter;

    public UserImporter(TenantServiceAccessor serviceAccessor, ImportOrganizationStrategy strategy, long userIdFromSession, CustomUserInfoValueImporter infoValueImporter) {
        this.strategy = strategy;
        this.userIdFromSession = userIdFromSession;
        this.infoValueImporter = infoValueImporter;
        this.identityService = serviceAccessor.getIdentityService();
    }

    public Map<String, SUser> importUsers(List<ExportedUser> usersToImport) throws SBonitaException {
        HashMap<String, SUser> userNameToSUsers = new HashMap<String, SUser>((int)Math.min(Integer.MAX_VALUE, this.identityService.getNumberOfUsers()));
        for (ExportedUser userToImport : usersToImport) {
            SUser sUser = null;
            if (this.hasUserWithUserName(userToImport.getUserName())) {
                sUser = this.identityService.getUserByUserName(userToImport.getUserName());
                this.strategy.foundExistingUser(sUser, userToImport);
            } else {
                sUser = this.addAllUserInfo(userToImport);
            }
            userNameToSUsers.put(sUser.getUserName(), sUser);
        }
        return userNameToSUsers;
    }

    private boolean hasUserWithUserName(String userName) throws SBonitaSearchException {
        SUserBuilderFactory keyProvider = BuilderFactory.get(SUserBuilderFactory.class);
        FilterOption filter = new FilterOption(SUser.class, keyProvider.getUserNameKey(), userName);
        QueryOptions queryOptions = new QueryOptions(Collections.singletonList(filter), null);
        long numberOfUsers = this.identityService.getNumberOfUsers(queryOptions);
        return numberOfUsers > 0L;
    }

    private SUser addAllUserInfo(ExportedUser userToImport) throws SBonitaException {
        SUser persistedUser = this.addUser(userToImport);
        this.addContactInfo(userToImport, persistedUser);
        this.infoValueImporter.imporCustomUserInfoValues(userToImport.getCustomUserInfoValues(), persistedUser.getId());
        return persistedUser;
    }

    private void addContactInfo(ExportedUser userToImport, SUser persistedUser) throws SUserCreationException {
        SContactInfo persoSContactInfo = ModelConvertor.constructSUserContactInfo(userToImport, true, persistedUser.getId());
        this.identityService.createUserContactInfo(persoSContactInfo);
        SContactInfo professSContactInfo = ModelConvertor.constructSUserContactInfo(userToImport, false, persistedUser.getId());
        this.identityService.createUserContactInfo(professSContactInfo);
    }

    private SUser addUser(ExportedUser user) throws SUserCreationException {
        SUser sUser = user.isPasswordEncrypted() ? this.identityService.createUserWithoutEncryptingPassword(this.constructSUser(user)) : this.identityService.createUser(this.constructSUser(user));
        return sUser;
    }

    private SUser constructSUser(ExportedUser exportedUser) {
        SUserBuilder userBuilder = BuilderFactory.get(SUserBuilderFactory.class).createNewInstance();
        long now = System.currentTimeMillis();
        userBuilder.setCreationDate(now);
        userBuilder.setLastUpdate(now);
        userBuilder.setLastConnection(null);
        userBuilder.setUserName(exportedUser.getUserName());
        userBuilder.setPassword(exportedUser.getPassword());
        userBuilder.setFirstName(exportedUser.getFirstName());
        userBuilder.setLastName(exportedUser.getLastName());
        userBuilder.setIconName(exportedUser.getIconName());
        userBuilder.setIconPath(exportedUser.getIconPath());
        userBuilder.setJobTitle(exportedUser.getJobTitle());
        userBuilder.setTitle(exportedUser.getTitle());
        userBuilder.setCreatedBy(exportedUser.getCreatedBy() == 0L ? this.userIdFromSession : exportedUser.getCreatedBy());
        userBuilder.setManagerUserId(exportedUser.getManagerUserId());
        userBuilder.setEnabled(exportedUser.isEnabled());
        return userBuilder.done();
    }
}

