/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.DBConfiguration;
import org.bonitasoft.engine.persistence.DBConfigurationsProvider;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SQLTransformer;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.sequence.SequenceManager;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.TenantPersistenceService;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;

public abstract class AbstractDBPersistenceService
implements TenantPersistenceService {
    private final List<String> createTablesFiles = new ArrayList<String>();
    private final List<String> postCreateStructureFiles = new ArrayList<String>();
    private final List<String> preDropStructureFiles = new ArrayList<String>();
    private final List<String> dropTablesFiles = new ArrayList<String>();
    private final List<String> initTablesFiles = new ArrayList<String>();
    private final List<String> cleanTablesFiles = new ArrayList<String>();
    private final List<String> deleteObjectsFiles = new ArrayList<String>();
    private final Map<String, SQLTransformer> sqlTransformers = new HashMap<String, SQLTransformer>();
    private final String statementDelimiter;
    private final String likeEscapeCharacter;
    private final String name;
    private final SequenceManager sequenceManager;
    protected final DataSource datasource;
    private final Set<Class<? extends PersistentObject>> wordSearchExclusionMappings = new HashSet<Class<? extends PersistentObject>>();
    private final boolean enableWordSearch;
    protected final TechnicalLoggerService logger;

    public AbstractDBPersistenceService(String name, String statementDelimiter, String likeEscapeCharacter, boolean enableWordSearch, Set<String> wordSearchExclusionMappings, TechnicalLoggerService logger) throws ClassNotFoundException {
        this.name = name;
        this.sequenceManager = null;
        this.datasource = null;
        this.statementDelimiter = statementDelimiter;
        this.likeEscapeCharacter = likeEscapeCharacter;
        this.enableWordSearch = enableWordSearch;
        if (wordSearchExclusionMappings != null) {
            for (String wordSearchExclusionMapping : wordSearchExclusionMappings) {
                Class<?> clazz = Class.forName(wordSearchExclusionMapping);
                if (!PersistentObject.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Unable to add a word search exclusion mapping for class " + clazz + " because it does not implements " + PersistentObject.class);
                }
                this.wordSearchExclusionMappings.add(clazz);
            }
        }
        this.logger = logger;
    }

    public AbstractDBPersistenceService(String name, DBConfigurationsProvider dbConfigurationsProvider, String statementDelimiter, String likeEscapeCharacter, SequenceManager sequenceManager, DataSource datasource, boolean enableWordSearch, Set<String> wordSearchExclusionMappings, TechnicalLoggerService logger) throws ClassNotFoundException {
        this.name = name;
        this.sequenceManager = sequenceManager;
        this.datasource = datasource;
        this.initTablesFiles(dbConfigurationsProvider, name);
        this.statementDelimiter = statementDelimiter;
        this.likeEscapeCharacter = likeEscapeCharacter;
        this.enableWordSearch = enableWordSearch;
        this.logger = logger;
        if (enableWordSearch && logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "The word based search feature is experimental, using it in production may impact performances.");
        }
        if (wordSearchExclusionMappings != null && !wordSearchExclusionMappings.isEmpty()) {
            if (!enableWordSearch && logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
                logger.log(this.getClass(), TechnicalLogSeverity.INFO, "You defined an exclusion mapping for the word based search feature, but it is not enabled.");
            }
            for (String wordSearchExclusionMapping : wordSearchExclusionMappings) {
                Class<?> clazz = Class.forName(wordSearchExclusionMapping);
                if (!PersistentObject.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException("Unable to add a word search exclusion mapping for class " + clazz + " because it does not implements " + PersistentObject.class);
                }
                this.wordSearchExclusionMappings.add(clazz);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean isWordSearchEnabled(Class<? extends PersistentObject> entityClass) {
        if (!this.enableWordSearch || entityClass == null) {
            return false;
        }
        for (Class<? extends PersistentObject> exclusion : this.wordSearchExclusionMappings) {
            if (!exclusion.isAssignableFrom(entityClass)) continue;
            return false;
        }
        return true;
    }

    protected void initTablesFiles(DBConfigurationsProvider dbConfigurationsProvider, String persistenceDBConfigFilter) {
        if (dbConfigurationsProvider != null) {
            for (DBConfiguration dbConfiguration : dbConfigurationsProvider.getMatchingTenantConfigurations(persistenceDBConfigFilter)) {
                if (dbConfiguration.hasCreateTablesFile()) {
                    this.createTablesFiles.add(dbConfiguration.getCreateTablesFile());
                }
                if (dbConfiguration.hasInitTablesFile()) {
                    this.initTablesFiles.add(dbConfiguration.getInitTablesFile());
                }
                if (dbConfiguration.hasCleanTablesFile()) {
                    this.cleanTablesFiles.add(dbConfiguration.getCleanTablesFile());
                }
                if (dbConfiguration.hasDropTablesFile()) {
                    this.dropTablesFiles.add(dbConfiguration.getDropTablesFile());
                }
                if (dbConfiguration.hasDeleteTenantObjectsFile()) {
                    this.deleteObjectsFiles.add(dbConfiguration.getDeleteTenantObjectsFile());
                }
                if (dbConfiguration.hasPostCreateStructureFile()) {
                    this.postCreateStructureFiles.add(dbConfiguration.getPostCreateStructureFile());
                }
                if (dbConfiguration.hasPreDropStructureFile()) {
                    this.preDropStructureFiles.add(dbConfiguration.getPreDropStructureFile());
                }
                if (!dbConfiguration.hasSqlTransformers()) continue;
                this.sqlTransformers.putAll(dbConfiguration.getSqlTransformers());
            }
        }
    }

    @Override
    public void createStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.createTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void postCreateStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.postCreateStructureFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void preDropStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.preDropStructureFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void cleanStructure() throws SPersistenceException, IOException {
        for (String sqlResource : this.cleanTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void deleteStructure() throws SPersistenceException, IOException {
        this.sequenceManager.clear();
        for (String sqlResource : this.dropTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, null, true);
        }
    }

    @Override
    public void initializeStructure() throws SPersistenceException, IOException {
        this.initializeStructure(Collections.<String, String>emptyMap());
    }

    @Override
    public void initializeStructure(Map<String, String> replacements) throws SPersistenceException, IOException {
        for (String sqlResource : this.initTablesFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, replacements, false);
        }
    }

    @Override
    public void deleteTenant(long tenantId) throws SPersistenceException, IOException {
        this.sequenceManager.clear(tenantId);
        Map<String, String> replacements = Collections.singletonMap("tenantid", String.valueOf(tenantId));
        for (String sqlResource : this.deleteObjectsFiles) {
            this.executeSQL(sqlResource, this.statementDelimiter, replacements, true);
        }
    }

    private void executeSQL(String sqlResource, String statementDelimiter, Map<String, String> replacements, boolean useDataSourceConnection) throws SPersistenceException, IOException {
        if (replacements != null) {
            HashMap<String, String> replacementsWithVarDelimiters = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                if (entry.getKey().charAt(0) == '$') {
                    replacementsWithVarDelimiters.put(entry.getKey(), entry.getValue());
                    continue;
                }
                replacementsWithVarDelimiters.put("\\$\\{" + entry.getKey() + "\\}", entry.getValue());
            }
            this.doExecuteSQL(sqlResource, statementDelimiter, replacementsWithVarDelimiters, useDataSourceConnection);
        } else {
            this.doExecuteSQL(sqlResource, statementDelimiter, null, useDataSourceConnection);
        }
    }

    protected SQLTransformer getSqlTransformer(String className) {
        return this.sqlTransformers.get(className);
    }

    protected List<SQLTransformer> getSqlTransformers() {
        return new ArrayList<SQLTransformer>(this.sqlTransformers.values());
    }

    protected abstract void doExecuteSQL(String var1, String var2, Map<String, String> var3, boolean var4) throws SPersistenceException, IOException;

    @Override
    public <T extends PersistentObject> long getNumberOfEntities(Class<T> entityClass, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        return this.getNumberOfEntities(entityClass, null, options, parameters);
    }

    @Override
    public <T extends PersistentObject> long getNumberOfEntities(Class<T> entityClass, String querySuffix, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        List<Object> filters = options == null ? Collections.emptyList() : options.getFilters();
        String queryName = this.getQueryName("getNumberOf", querySuffix, entityClass, filters);
        SelectListDescriptor<Long> descriptor = new SelectListDescriptor<Long>(queryName, parameters, entityClass, Long.class, options);
        return this.selectList(descriptor).get(0);
    }

    @Override
    public <T extends PersistentObject> List<T> searchEntity(Class<T> entityClass, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        return this.searchEntity(entityClass, null, options, parameters);
    }

    @Override
    public <T extends PersistentObject> List<T> searchEntity(Class<T> entityClass, String querySuffix, QueryOptions options, Map<String, Object> parameters) throws SBonitaReadException {
        String queryName = this.getQueryName("search", querySuffix, entityClass, options.getFilters());
        SelectListDescriptor descriptor = new SelectListDescriptor(queryName, parameters, entityClass, options);
        return this.selectList(descriptor);
    }

    private <T extends PersistentObject> String getQueryName(String prefix, String suffix, Class<T> entityClass, List<FilterOption> filters) {
        TreeSet<String> query = new TreeSet<String>();
        for (FilterOption filter : filters) {
            if (filter.getPersistentClass() == null) continue;
            query.add(filter.getPersistentClass().getSimpleName());
        }
        String searchOnClassName = entityClass.getSimpleName();
        query.remove(searchOnClassName);
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(searchOnClassName);
        if (!query.isEmpty()) {
            builder.append("with");
        }
        for (String entity : query) {
            builder.append(entity);
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }

    protected abstract long getTenantId() throws STenantIdNotSetException;

    protected SequenceManager getSequenceManager() {
        return this.sequenceManager;
    }

    protected void setId(PersistentObject entity) throws SPersistenceException {
        if (entity == null) {
            return;
        }
        Long id = null;
        try {
            id = entity.getId();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (id == null || id == -1L || id == 0L) {
            try {
                id = this.getSequenceManager().getNextId(entity.getClass().getName(), this.getTenantId());
                ClassReflector.invokeSetter(entity, "setId", Long.TYPE, id);
            }
            catch (Exception e) {
                throw new SPersistenceException("Problem while saving entity: " + entity + " with id: " + id, e);
            }
        }
    }

    protected String buildLikeEscapeClause(String term, String prefixPattern, String suffixPattern) {
        return " LIKE '" + (prefixPattern != null ? prefixPattern : "") + this.escapeTerm(term) + (suffixPattern != null ? suffixPattern : "") + "' ESCAPE '" + this.getLikeEscapeCharacter() + "'";
    }

    protected String escapeTerm(String term) {
        return term.replaceAll("'", "''").replaceAll(this.getLikeEscapeCharacter(), this.getLikeEscapeCharacter() + this.getLikeEscapeCharacter()).replaceAll("%", this.getLikeEscapeCharacter() + "%").replaceAll("_", this.getLikeEscapeCharacter() + "_");
    }

    protected String getLikeEscapeCharacter() {
        return this.likeEscapeCharacter;
    }
}

