/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.profile.ProfileImportStategy;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.exception.profile.SProfileUpdateException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryDeletionException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberDeletionException;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.profile.model.SProfile;

public class DeleteExistingImportStrategy
extends ProfileImportStategy {
    public DeleteExistingImportStrategy(ProfileService profileService) {
        super(profileService);
    }

    @Override
    public void beforeImport() throws ExecutionException {
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(new OrderByOption(SProfile.class, "name", OrderByType.ASC)), Collections.<FilterOption>emptyList(), null);
        try {
            List<SProfile> profiles;
            do {
                profiles = this.getProfileService().searchProfiles(queryOptions);
                for (SProfile sProfile : profiles) {
                    this.getProfileService().deleteProfile(sProfile);
                }
            } while (!profiles.isEmpty());
        }
        catch (SBonitaException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Override
    public SProfile whenProfileExists(long importerId, ExportedProfile exportedProfile, SProfile existingProfile) throws ExecutionException, SProfileEntryDeletionException, SProfileMemberDeletionException, SProfileUpdateException {
        return null;
    }

    @Override
    public boolean canCreateProfileIfNotExists(ExportedProfile exportedProfile) {
        return true;
    }
}

