/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search;

import java.util.List;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeType;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAAutomaticTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SASendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAUserTaskInstance;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchArchivedActivityInstanceDescriptor;
import org.bonitasoft.engine.search.impl.SearchFilter;
import org.bonitasoft.engine.service.ModelConvertor;

public abstract class AbstractArchiveActivityInstanceSearchEntity
extends AbstractSearchEntity<ArchivedActivityInstance, SAActivityInstance> {
    private final FlowNodeStateManager flowNodeStateManager;
    private final Class<? extends PersistentObject> entityClass;

    public AbstractArchiveActivityInstanceSearchEntity(SearchArchivedActivityInstanceDescriptor searchDescriptor, SearchOptions searchOptions, FlowNodeStateManager flowNodeStateManager) {
        super(searchDescriptor, searchOptions);
        this.flowNodeStateManager = flowNodeStateManager;
        this.entityClass = this.getEntityClass(searchOptions);
    }

    @Override
    public List<ArchivedActivityInstance> convertToClientObjects(List<SAActivityInstance> serverObjects) {
        return ModelConvertor.toArchivedActivityInstances(serverObjects, this.flowNodeStateManager);
    }

    protected Class<? extends PersistentObject> getEntityClass(SearchOptions searchOptions) {
        FlowNodeType activityType;
        Class<SAActivityInstance> entityClass = SAActivityInstance.class;
        SearchFilter searchFilter = this.getSearchFilter(searchOptions, "activityType");
        if (searchFilter != null && (activityType = (FlowNodeType)searchFilter.getValue()) != null) {
            switch (activityType) {
                case AUTOMATIC_TASK: {
                    entityClass = SAAutomaticTaskInstance.class;
                    break;
                }
                case MANUAL_TASK: {
                    entityClass = SAManualTaskInstance.class;
                    break;
                }
                case USER_TASK: {
                    entityClass = SAUserTaskInstance.class;
                    break;
                }
                case HUMAN_TASK: {
                    entityClass = SAHumanTaskInstance.class;
                    break;
                }
                case RECEIVE_TASK: {
                    entityClass = SAReceiveTaskInstance.class;
                    break;
                }
                case SEND_TASK: {
                    entityClass = SASendTaskInstance.class;
                    break;
                }
                default: {
                    entityClass = SAActivityInstance.class;
                }
            }
            searchOptions.getFilters().remove(searchFilter);
        }
        return entityClass;
    }

    protected Class<? extends PersistentObject> getEntityClass() {
        return this.entityClass;
    }
}

