/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.exception.BonitaHomeConfigurationException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.service.APIAccessResolver;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.SessionAccessorAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public final class ServiceAccessorFactory {
    private static final String DB_VENDOR = "db.vendor";
    private static final ServiceAccessorFactory INSTANCE = new ServiceAccessorFactory();
    private Properties properties = null;
    private SessionAccessorAccessor sessionAccessorAccessor;
    private PlatformServiceAccessor platformServiceAccessor;
    private final Map<Long, TenantServiceAccessor> tenantServiceAccessor = new HashMap<Long, TenantServiceAccessor>();
    private APIAccessResolver apiAccessResolver;

    protected ServiceAccessorFactory() {
    }

    public static ServiceAccessorFactory getInstance() {
        return INSTANCE;
    }

    public synchronized PlatformServiceAccessor createPlatformServiceAccessor() throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        if (this.platformServiceAccessor == null) {
            this.initPropertiesIfNeeded();
            String platformClassName = this.properties.getProperty("platformClassName");
            if (platformClassName == null) {
                throw new BonitaHomeConfigurationException("platformClassName not set in bonita-platform.properties");
            }
            this.platformServiceAccessor = (PlatformServiceAccessor)Class.forName(platformClassName).newInstance();
        }
        return this.platformServiceAccessor;
    }

    private void initPropertiesIfNeeded() throws BonitaHomeNotSetException, IOException {
        if (this.properties == null) {
            this.properties = BonitaHomeServer.getInstance().getPlatformProperties();
            String dbVendor = this.properties.getProperty(DB_VENDOR);
            System.setProperty(DB_VENDOR, dbVendor);
        }
    }

    public synchronized TenantServiceAccessor createTenantServiceAccessor(long tenantId) throws SBonitaException, BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (!this.tenantServiceAccessor.containsKey(tenantId)) {
            this.initPropertiesIfNeeded();
            String tenantClassName = this.properties.getProperty("tenantClassName");
            if (tenantClassName == null) {
                throw new BonitaHomeConfigurationException("tenantClassName not set in bonita-platform.properties");
            }
            Class<TenantServiceAccessor> tenantClass = ClassReflector.getClass(TenantServiceAccessor.class, tenantClassName);
            Constructor<TenantServiceAccessor> constructor = tenantClass.getConstructor(Long.class);
            this.tenantServiceAccessor.put(tenantId, constructor.newInstance(tenantId));
        }
        return this.tenantServiceAccessor.get(tenantId);
    }

    public synchronized SessionAccessor createSessionAccessor() throws BonitaHomeNotSetException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, BonitaHomeConfigurationException {
        if (this.sessionAccessorAccessor == null) {
            this.initPropertiesIfNeeded();
            String sessionAccessorStr = this.properties.getProperty("sessionAccessor");
            if (sessionAccessorStr == null) {
                throw new BonitaHomeConfigurationException("sessionAccessor not set in bonita-platform.properties");
            }
            this.sessionAccessorAccessor = (SessionAccessorAccessor)Class.forName(sessionAccessorStr).newInstance();
        }
        return this.sessionAccessorAccessor.getSessionAccessor();
    }

    public synchronized APIAccessResolver createAPIAccessResolver() throws BonitaHomeNotSetException, IOException, BonitaHomeConfigurationException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.apiAccessResolver == null) {
            this.initPropertiesIfNeeded();
            String sessionAccessorStr = this.properties.getProperty("apiAccessResolver");
            if (sessionAccessorStr == null) {
                throw new BonitaHomeConfigurationException("ApiAccessResolver not set in bonita-platform.properties");
            }
            this.apiAccessResolver = (APIAccessResolver)Class.forName(sessionAccessorStr).newInstance();
        }
        return this.apiAccessResolver;
    }

    public synchronized void destroyAccessors() {
        Set<Map.Entry<Long, TenantServiceAccessor>> tenantAccessors = this.tenantServiceAccessor.entrySet();
        for (Map.Entry<Long, TenantServiceAccessor> tenantAccessor : tenantAccessors) {
            tenantAccessor.getValue().destroy();
        }
        this.tenantServiceAccessor.clear();
        if (this.platformServiceAccessor != null) {
            this.platformServiceAccessor.destroy();
            this.platformServiceAccessor = null;
        }
        if (this.sessionAccessorAccessor != null) {
            this.sessionAccessorAccessor.destroy();
            this.sessionAccessorAccessor = null;
        }
    }
}

