/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.session.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.bonitasoft.engine.session.SSessionAlreadyExistsException;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionProvider;
import org.bonitasoft.engine.session.model.SSession;

public abstract class AbstractSessionProvider
implements SessionProvider {
    protected abstract Map<Long, SSession> getSessions();

    protected SSession putSession(SSession session, long id) {
        return this.getSessions().put(id, session);
    }

    @Override
    public synchronized void addSession(SSession session) throws SSessionAlreadyExistsException {
        long id = session.getId();
        if (this.getSessions().containsKey(id)) {
            throw new SSessionAlreadyExistsException("A session wih id \"" + id + "\" already exists");
        }
        this.putSession(session, id);
    }

    @Override
    public synchronized void removeSession(long sessionId) throws SSessionNotFoundException {
        SSession session = this.getSessions().remove(sessionId);
        if (session == null) {
            throw new SSessionNotFoundException("No session found with id \"" + sessionId + "\"");
        }
    }

    @Override
    public synchronized SSession getSession(long sessionId) throws SSessionNotFoundException {
        SSession session = this.getSessions().get(sessionId);
        if (session == null) {
            throw new SSessionNotFoundException("No session found with id \"" + sessionId + "\"");
        }
        return session;
    }

    @Override
    public synchronized void updateSession(SSession session) throws SSessionNotFoundException {
        long id = session.getId();
        if (!this.getSessions().containsKey(id)) {
            throw new SSessionNotFoundException("No session found with id \"" + id + "\"");
        }
        this.putSession(session, id);
    }

    @Override
    public synchronized void cleanInvalidSessions() {
        ArrayList<Long> invalidSessionIds = new ArrayList<Long>();
        for (SSession session : this.getSessions().values()) {
            if (session.isValid()) continue;
            invalidSessionIds.add(session.getId());
        }
        for (Long invalidSessionId : invalidSessionIds) {
            this.getSessions().remove(invalidSessionId);
        }
    }

    @Override
    public synchronized void removeSessions() {
        this.getSessions().clear();
    }

    @Override
    public synchronized void deleteSessionsOfTenant(long tenantId, boolean keepTechnicalSessions) {
        Iterator<SSession> iterator = this.getSessions().values().iterator();
        while (iterator.hasNext()) {
            SSession sSession = iterator.next();
            if (tenantId != sSession.getTenantId() || keepTechnicalSessions && sSession.isTechnicalUser()) continue;
            iterator.remove();
        }
    }
}

