/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.bonitasoft.engine.cache.CommonCacheService;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.synchro.AbstractSynchroService;

public class SynchroServiceImpl
extends AbstractSynchroService {
    private final Map<Map<String, Serializable>, String> waiters;
    private final Map<String, Serializable> eventKeyAndIdMap;
    private final Map<String, Semaphore> eventSemaphores;
    private final Lock lock = new SynchroServiceImplReentrantLock();

    private SynchroServiceImpl(int initialCapacity, TechnicalLoggerService logger, CommonCacheService cacheService) {
        super(logger, cacheService);
        this.waiters = new HashMap<Map<String, Serializable>, String>(initialCapacity);
        this.eventKeyAndIdMap = new HashMap<String, Serializable>(initialCapacity);
        this.eventSemaphores = new HashMap<String, Semaphore>();
    }

    @Override
    protected Map<Map<String, Serializable>, String> getWaitersMap() {
        return this.waiters;
    }

    @Override
    protected Map<String, Serializable> getEventKeyAndIdMap() {
        return this.eventKeyAndIdMap;
    }

    @Override
    protected Lock getServiceLock() {
        return this.lock;
    }

    @Override
    protected void releaseWaiter(String semaphoreKey) {
        Semaphore semaphore = this.eventSemaphores.get(semaphoreKey);
        if (semaphore != null) {
            semaphore.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable waitForEvent(Map<String, Serializable> event, long timeout) throws InterruptedException, TimeoutException {
        Serializable id = null;
        String semaphoreKey = null;
        Semaphore semaphore = null;
        this.getServiceLock().lock();
        try {
            id = this.getFiredAndRemoveIt(event);
            if (id == null) {
                semaphoreKey = this.getSemaphoreKey(event);
                semaphore = new Semaphore(1);
                this.eventSemaphores.put(semaphoreKey, semaphore);
                semaphore.acquire(1);
                this.getWaitersMap().put(event, semaphoreKey);
            }
        }
        finally {
            this.getServiceLock().unlock();
        }
        if (semaphore != null) {
            try {
                if (!semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                    this.throwTimeout(event, timeout);
                }
            }
            catch (InterruptedException e) {
                this.throwTimeout(event, timeout);
            }
            finally {
                this.getWaitersMap().remove(event);
            }
            return this.getEventKeyAndIdMap().get(semaphoreKey);
        }
        return id;
    }

    private String getSemaphoreKey(Map<String, Serializable> event) {
        StringBuilder sb = new StringBuilder();
        TreeMap<String, Serializable> orderedMap = new TreeMap<String, Serializable>(event);
        boolean first = true;
        for (Map.Entry<String, Serializable> entry : orderedMap.entrySet()) {
            if (!first) {
                sb.append(";;;;;");
            } else {
                first = false;
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static final class SynchroServiceImplReentrantLock
    extends ReentrantLock {
        private SynchroServiceImplReentrantLock() {
        }
    }
}

