/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.tracking;

import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.tracking.Clock;
import org.bonitasoft.engine.tracking.TimeTracker;

public class FlushThread
extends Thread {
    private final TimeTracker timeTracker;
    private final long flushIntervalInMilliSeconds;
    private final Clock clock;
    private final TechnicalLoggerService logger;

    public FlushThread(Clock clock, long flushIntervalInMilliSeconds, TimeTracker timeTracker, TechnicalLoggerService logger) {
        super("TimeTracker-FlushThread");
        this.clock = clock;
        this.logger = logger;
        this.flushIntervalInMilliSeconds = flushIntervalInMilliSeconds;
        this.timeTracker = timeTracker;
    }

    @Override
    public void run() {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Starting " + this.getName() + "...");
        }
        while (true) {
            try {
                this.clock.sleep(this.flushIntervalInMilliSeconds);
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                this.timeTracker.flush();
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) continue;
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "Exception caught while flushing: " + e.getMessage(), e);
            }
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, this.getName() + " stopped.");
        }
    }
}

