/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.tracking.csv;

import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.tracking.FlushEvent;
import org.bonitasoft.engine.tracking.FlushEventListener;
import org.bonitasoft.engine.tracking.Record;
import org.bonitasoft.engine.tracking.csv.CSVFlushResult;
import org.bonitasoft.engine.tracking.csv.CSVUtil;

public class CSVFlushEventListener
implements FlushEventListener {
    private final String csvSeparator;
    private final String outputFolder;
    private final TechnicalLoggerService logger;

    public CSVFlushEventListener(TechnicalLoggerService logger, String outputFolder, String csvSeparator) {
        this.logger = logger;
        this.outputFolder = outputFolder;
        this.csvSeparator = csvSeparator;
        File outputFolderFile = new File(outputFolder);
        if (!outputFolderFile.exists()) {
            throw new RuntimeException("Output folder does not exist: " + outputFolder);
        }
        if (!outputFolderFile.isDirectory()) {
            throw new RuntimeException("Output folder is not a directory: " + outputFolder);
        }
    }

    @Override
    public CSVFlushResult flush(FlushEvent flushEvent) throws Exception {
        List<Record> records = flushEvent.getRecords();
        ArrayList<List<String>> csvContent = new ArrayList<List<String>>();
        csvContent.add(this.getHeaderRow());
        for (Record record : records) {
            List<String> row = this.getRow(record);
            csvContent.add(row);
        }
        String timestamp = CSVUtil.getFileTimestamp(System.currentTimeMillis());
        File outputFile = new File(this.outputFolder, timestamp + "_bonita_timetracker_" + UUID.randomUUID().toString() + ".csv");
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Generating csv file to: " + outputFile);
        }
        CSVUtil.writeCSV(outputFile, csvContent, this.csvSeparator);
        return new CSVFlushResult(flushEvent, outputFile);
    }

    private List<String> getRow(Record record) {
        long timestamp = record.getTimestamp();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(timestamp);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int dayOfMonth = cal.get(5);
        int hourOfDay = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int milisecond = cal.get(14);
        ArrayList<String> row = new ArrayList<String>();
        row.add(String.valueOf(timestamp));
        row.add(String.valueOf(year));
        row.add(String.valueOf(month));
        row.add(String.valueOf(dayOfMonth));
        row.add(String.valueOf(hourOfDay));
        row.add(String.valueOf(minute));
        row.add(String.valueOf(second));
        row.add(String.valueOf(milisecond));
        row.add(String.valueOf(record.getDuration()));
        row.add(record.getName());
        row.add(record.getDescription());
        return row;
    }

    private List<String> getHeaderRow() {
        ArrayList<String> header = new ArrayList<String>();
        header.add("timestamp");
        header.add("year");
        header.add("month");
        header.add("dayOfMonth");
        header.add("hourOfDay");
        header.add("minute");
        header.add("second");
        header.add("milisecond");
        header.add("duration");
        header.add("name");
        header.add("description");
        return header;
    }
}

