/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLNode {
    private final String name;
    private final Map<String, String> attributes;
    private final List<XMLNode> childNodes;
    private String content;

    public XMLNode(String name) {
        this.name = name;
        this.attributes = new HashMap<String, String>();
        this.childNodes = new ArrayList<XMLNode>();
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void addAttribute(String name, boolean value) {
        this.attributes.put(name, new Boolean(value).toString());
    }

    public void addChild(XMLNode node) {
        if (node != null) {
            this.childNodes.add(node);
        }
    }

    public void addChild(String name, String content) {
        if (name != null && content != null) {
            XMLNode node = new XMLNode(name);
            node.setContent(content);
            this.childNodes.add(node);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<XMLNode> getChildNodes() {
        return this.childNodes;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }
}

