/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.command;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.ProcessStarter;
import org.bonitasoft.engine.bpm.process.ProcessActivationException;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessExecutionException;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.execution.AdvancedStartProcessValidator;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class AdvancedStartProcessCommand
extends CommandWithParameters {
    public static final String STARTED_BY = "started_by";
    public static final String PROCESS_DEFINITION_ID = "process_definition_id";
    public static final String ACTIVITY_NAME = "activity_name";
    public static final String OPERATIONS = "operations";
    public static final String CONTEXT = "context";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        long processDefinitionId = this.getProcessDefinitionId(parameters);
        List<String> activityNames = Collections.singletonList(this.getActivityName(parameters));
        long startedBy = this.getStartedBy(parameters);
        Map<String, Serializable> context = this.getContext(parameters);
        List<Operation> operations = this.getOperations(parameters);
        try {
            this.validateInputs(serviceAccessor, processDefinitionId, activityNames);
            return this.startProcess(processDefinitionId, activityNames, startedBy, context, operations);
        }
        catch (SCommandExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SCommandExecutionException(e);
        }
    }

    private ProcessInstance startProcess(long processDefinitionId, List<String> activityNames, long startedBy, Map<String, Serializable> context, List<Operation> operations) throws ProcessDefinitionNotFoundException, ProcessActivationException, ProcessExecutionException {
        ProcessStarter starter = new ProcessStarter(startedBy, processDefinitionId, operations, context, activityNames);
        return starter.start();
    }

    private void validateInputs(TenantServiceAccessor serviceAccessor, long processDefinitionId, List<String> activityNames) throws SBonitaException, SCommandExecutionException {
        AdvancedStartProcessValidator validator = new AdvancedStartProcessValidator(serviceAccessor.getProcessDefinitionService(), processDefinitionId);
        List<String> problems = validator.validate(activityNames);
        this.handleProblems(problems);
    }

    private void handleProblems(List<String> problems) throws SCommandExecutionException {
        if (!problems.isEmpty()) {
            StringBuilder stb = new StringBuilder();
            for (String problem : problems) {
                stb.append(problem);
                stb.append("\n");
            }
            throw new SCommandExecutionException(stb.toString());
        }
    }

    private Long getStartedBy(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return this.getLongMandadoryParameter(parameters, STARTED_BY);
    }

    private Long getProcessDefinitionId(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return this.getLongMandadoryParameter(parameters, PROCESS_DEFINITION_ID);
    }

    private List<Operation> getOperations(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (List)this.getParameter(parameters, OPERATIONS);
    }

    private Map<String, Serializable> getContext(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return (Map)this.getParameter(parameters, CONTEXT);
    }

    private String getActivityName(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return this.getStringMandadoryParameter(parameters, ACTIVITY_NAME);
    }
}

