/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.expression.control.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.model.SExpression;

public class SExpressionContext
implements Serializable {
    private static final long serialVersionUID = 6417383664862870145L;
    public static final String CONTAINER_ID_KEY = "containerId";
    public static final String CONTAINER_TYPE_KEY = "containerType";
    public static final String TIME_KEY = "time";
    public static final String PROCESS_DEFINITION_ID_KEY = "processDefinitionId";
    public static final String PROCESS_DEFINITION_KEY = "processDefinition";
    private Long containerId;
    private String containerType;
    private ContainerState containerState;
    private long time;
    private Long processDefinitionId;
    private SProcessDefinition processDefinition;
    private Map<String, Object> inputValues;
    private boolean evaluateInDefinition = false;
    private Map<String, SExpression> dataMap;
    private Map<SExpression, String> invertedDataMap;

    public SExpressionContext() {
        this.inputValues = new HashMap<String, Object>();
    }

    public SExpressionContext(Long containerId, String containerType, Long processDefinitionId) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.processDefinitionId = processDefinitionId;
        this.inputValues = new HashMap<String, Object>();
    }

    public SExpressionContext(Long containerId, String containerType, Map<String, Serializable> inputValues) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : new HashMap<String, Serializable>(inputValues);
    }

    public SExpressionContext(Long containerId, String containerType, Map<String, Serializable> inputValues, long time) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : new HashMap<String, Serializable>(inputValues);
        this.time = time;
    }

    public SExpressionContext(long containerId, String containerType, Map<String, Object> inputValues) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : new HashMap<String, Object>(inputValues);
    }

    public Long getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(Long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setSerializableInputValues(Map<String, Serializable> inputValues) {
        if (inputValues != null) {
            this.inputValues.putAll(inputValues);
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Long getContainerId() {
        return this.containerId;
    }

    public void setContainerId(Long containerId) {
        this.containerId = containerId;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public ContainerState getContainerState() {
        return this.containerState;
    }

    public void setContainerState(ContainerState containerState) {
        this.containerState = containerState;
    }

    public Map<String, Object> getInputValues() {
        return this.inputValues;
    }

    public SProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(SProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        List<SDataDefinition> dataDefinitions = processContainer.getDataDefinitions();
        this.dataMap = new HashMap<String, SExpression>(dataDefinitions.size());
        this.invertedDataMap = new HashMap<SExpression, String>(dataDefinitions.size());
        for (SDataDefinition dataDef : dataDefinitions) {
            this.dataMap.put(dataDef.getName(), dataDef.getDefaultValueExpression());
            this.invertedDataMap.put(dataDef.getDefaultValueExpression(), dataDef.getName());
        }
    }

    public SExpression getDefaultValueFor(String name) {
        if (this.evaluateInDefinition) {
            return this.dataMap.get(name);
        }
        return null;
    }

    public String isDefaultValueOf(SExpression exp) {
        if (this.evaluateInDefinition) {
            return this.invertedDataMap.get(exp);
        }
        return null;
    }

    public void setInputValues(Map<String, Object> inputValues) {
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : inputValues;
    }

    public void setEvaluateInDefinition(boolean evaluateInDefinition) {
        this.evaluateInDefinition = evaluateInDefinition;
    }

    public boolean isEvaluateInDefinition() {
        return this.evaluateInDefinition;
    }

    public String toString() {
        return "context [containerId=" + this.containerId + ", containerType=" + this.containerType + ", processDefinitionId=" + this.processDefinitionId + (this.processDefinition != null ? ", processDefinition=" + this.processDefinition.getName() + " -- " + this.processDefinition.getVersion() : "") + "]";
    }
}

