/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.util.Properties;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.impl.SchedulerServiceImpl;
import org.bonitasoft.engine.scheduler.impl.TransactionalSimpleJobFactory;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;

public class BonitaSchedulerFactory
extends StdSchedulerFactory {
    private SchedulerServiceImpl schedulerService;
    private final TechnicalLoggerService logger;

    public BonitaSchedulerFactory(Properties props, TechnicalLoggerService logger) throws SchedulerException {
        super(props);
        this.logger = logger;
    }

    public Scheduler getScheduler() throws SchedulerException {
        Scheduler scheduler = super.getScheduler();
        scheduler.setJobFactory((JobFactory)new TransactionalSimpleJobFactory(this.schedulerService, this.logger));
        return scheduler;
    }

    public void setBOSSchedulerService(SchedulerServiceImpl schedulerService) {
        this.schedulerService = schedulerService;
    }
}

