/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.scheduler.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.StatelessJob;
import org.bonitasoft.engine.scheduler.impl.AbstractJobListener;
import org.bonitasoft.engine.scheduler.impl.JobWrapper;
import org.bonitasoft.engine.scheduler.impl.QuartzJob;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class TechnicalLoggerJobListener
extends AbstractJobListener {
    private static final String jobToBeFiredMessage = "Job FIRED : group=''{1}'', name=''{0}'', class=''{5}'', data=''{6}'', triggerGroup=''{4}'', triggerName=''{3}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}''";
    private static final String jobSuccessMessage = "Job COMPLETED : group=''{1}'', name=''{0}'', class=''{4}'', data=''{5}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}'', reports=''{3}''";
    private static final String jobFailedMessage = "Job FAILED : group=''{1}'', name=''{0}'', class=''{4}'', data=''{5}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}'', reports=''{3}''";
    private static final String jobWasVetoedMessage = "Job VETOED : group=''{1}'', name=''{0}'', class=''{5}'', triggerGroup=''{4}'', triggerName=''{3}'', at=''{2, date,HH:mm:ss MM/dd/yyyy}''";
    private final TechnicalLoggerService logger;
    private final boolean trace;
    private final boolean warning;

    public TechnicalLoggerJobListener(TechnicalLoggerService logger) {
        this.logger = logger;
        this.trace = logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        this.warning = logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING);
    }

    public String getName() {
        return "TechnicalLoggerJobListener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (this.trace) {
            Trigger trigger = context.getTrigger();
            TriggerKey triggerKey = trigger.getKey();
            JobDetail jobDetail = context.getJobDetail();
            JobKey jobKey = jobDetail.getKey();
            String jobType = this.getJobType(context.getJobInstance());
            Object[] args = new Object[]{jobKey.getName(), jobKey.getGroup(), new Date(), triggerKey.getName(), triggerKey.getGroup(), jobType, this.getJobDataValueAndType(jobDetail), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount()};
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, MessageFormat.format(jobToBeFiredMessage, args));
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (this.trace) {
            Trigger trigger = context.getTrigger();
            TriggerKey triggerKey = trigger.getKey();
            JobDetail jobDetail = context.getJobDetail();
            JobKey jobKey = jobDetail.getKey();
            String jobType = this.getJobType(context.getJobInstance());
            Object[] args = new Object[]{jobKey.getName(), jobKey.getGroup(), new Date(), triggerKey.getName(), triggerKey.getGroup(), jobType, trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount()};
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, MessageFormat.format(jobWasVetoedMessage, args));
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Trigger trigger = context.getTrigger();
        TriggerKey triggerKey = trigger.getKey();
        JobDetail jobDetail = context.getJobDetail();
        JobKey jobKey = jobDetail.getKey();
        String jobType = this.getJobType(context.getJobInstance());
        if (jobException != null) {
            if (this.warning) {
                Object[] args = new Object[]{jobKey.getName(), jobKey.getGroup(), new Date(), jobException.getMessage(), jobType, this.getJobDataValueAndType(jobDetail), triggerKey.getName(), triggerKey.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount()};
                this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, MessageFormat.format(jobFailedMessage, args), (Throwable)jobException);
            }
        } else if (this.trace) {
            Object[] args = new Object[]{jobKey.getName(), jobKey.getGroup(), new Date(), String.valueOf(context.getResult()), jobType, this.getJobDataValueAndType(jobDetail), triggerKey.getName(), triggerKey.getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount()};
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, MessageFormat.format(jobSuccessMessage, args));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getJobType(Job job) {
        Class<?> jobClass = job.getClass();
        if (!QuartzJob.class.isAssignableFrom(jobClass)) return jobClass.getName();
        StatelessJob bosJob = ((QuartzJob)job).getBosJob();
        if (bosJob == null) return "null";
        if (!(bosJob instanceof JobWrapper)) return bosJob.getClass().getName();
        return ((JobWrapper)bosJob).getStatelessJob().getClass().getName();
    }

    private List<JobDataValueAndType> getJobDataValueAndType(JobDetail jobDetail) {
        Set entries = jobDetail.getJobDataMap().getWrappedMap().entrySet();
        ArrayList<JobDataValueAndType> jobDatas = new ArrayList<JobDataValueAndType>(entries.size());
        for (Map.Entry<String, Object> entry : entries) {
            jobDatas.add(new JobDataValueAndType(entry));
        }
        return jobDatas;
    }

    private class JobDataValueAndType {
        private final String key;
        private final Object value;
        final String classOfValue;

        public JobDataValueAndType(Map.Entry<String, Object> jobData) {
            this.key = jobData.getKey();
            this.value = jobData.getValue();
            this.classOfValue = this.value.getClass().getName();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{'");
            builder.append(this.key).append("'='").append(this.value).append("', class='").append(this.classOfValue).append("'}");
            return builder.toString();
        }
    }
}

