/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.Collection;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.work.BonitaRunnable;
import org.bonitasoft.engine.work.BonitaWork;

public class SequenceRunnableExecutor
extends BonitaRunnable {
    private static final long serialVersionUID = -2502579611570147194L;
    private final Collection<BonitaWork> works;
    private boolean cancelled = false;
    private final TechnicalLoggerService loggerService;

    public SequenceRunnableExecutor(Collection<BonitaWork> works, long tenantId, TechnicalLoggerService loggerService) {
        super(tenantId);
        this.works = works;
        this.loggerService = loggerService;
    }

    @Override
    public void innerRun() {
        for (BonitaWork work : this.works) {
            if (this.cancelled) continue;
            try {
                work.run();
            }
            catch (Exception t) {
                if (!this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) continue;
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "Error while executing one work in the list of works : " + work.getDescription(), t);
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public String toString() {
        return "sequence: " + this.works.toString();
    }
}

