/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.data.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.data.instance.TransientDataService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceNotFoundException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public class TransientDataExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    private final TransientDataService transientDataService;

    public TransientDataExpressionExecutorStrategy(TransientDataService transientDataService) {
        this.transientDataService = transientDataService;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        return this.evaluate(Arrays.asList(expression), dependencyValues, resolvedExpressions, containerState).get(0);
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_TRANSIENT_VARIABLE;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException, SExpressionDependencyMissingException {
        int maxExpressionSize = expressions.size();
        ArrayList<String> dataNames = new ArrayList<String>(maxExpressionSize);
        HashMap<String, Serializable> results = new HashMap<String, Serializable>(maxExpressionSize);
        for (SExpression sExpression : expressions) {
            String dataName = sExpression.getContent();
            if (dependencyValues.containsKey(dataName)) {
                Serializable value = (Serializable)dependencyValues.get(dataName);
                results.put(dataName, value);
                continue;
            }
            dataNames.add(dataName);
        }
        if (dataNames.isEmpty()) {
            return this.buildExpressionResultSameOrderAsInputList(expressions, results);
        }
        if (dependencyValues != null && dependencyValues.containsKey("containerId") && dependencyValues.containsKey("containerType")) {
            String currentData = null;
            try {
                long containerId = (Long)dependencyValues.get("containerId");
                String containerType = (String)dependencyValues.get("containerType");
                Iterator i$ = dataNames.iterator();
                while (i$.hasNext()) {
                    SDataInstance dataInstance;
                    String name;
                    currentData = name = (String)i$.next();
                    try {
                        dataInstance = this.transientDataService.getDataInstance(name, containerId, containerType);
                    }
                    catch (SDataInstanceNotFoundException e) {
                        dataInstance = this.handleDataNotFound(name, containerId, containerType, e);
                    }
                    results.put(dataInstance.getName(), dataInstance.getValue());
                }
                return this.buildExpressionResultSameOrderAsInputList(expressions, results);
            }
            catch (SBonitaReadException e) {
                throw new SExpressionEvaluationException("Can't read transient data", e, currentData);
            }
            catch (SDataInstanceException e) {
                throw new SExpressionEvaluationException("Can't read transient data", e, currentData);
            }
        }
        throw new SExpressionDependencyMissingException("The context to evaluate the data '" + dataNames + "' was not set");
    }

    protected SDataInstance handleDataNotFound(String name, long containerId, String containerType, SDataInstanceNotFoundException e) throws SDataInstanceNotFoundException, SBonitaReadException, SDataInstanceException {
        throw e;
    }

    private List<Object> buildExpressionResultSameOrderAsInputList(List<SExpression> expressions, Map<String, Serializable> results) {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(results.get(expression.getContent()));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }
}

