/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.dependency.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.commons.CollectionUtil;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.dependency.ArtifactAccessor;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyCreationException;
import org.bonitasoft.engine.dependency.SDependencyDeletionException;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.SDependencyMappingNotFoundException;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.dependency.model.SDependencyMapping;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.dependency.model.builder.SDependencyBuilderFactory;
import org.bonitasoft.engine.dependency.model.builder.SDependencyLogBuilder;
import org.bonitasoft.engine.dependency.model.builder.SDependencyLogBuilderFactory;
import org.bonitasoft.engine.dependency.model.builder.SDependencyMappingBuilderFactory;
import org.bonitasoft.engine.dependency.model.builder.SDependencyMappingLogBuilder;
import org.bonitasoft.engine.dependency.model.builder.SDependencyMappingLogBuilderFactory;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class DependencyServiceImpl
implements DependencyService {
    private static final int BATCH_SIZE = 100;
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;
    private final ClassLoaderService classLoaderService;
    private final Map<String, Long> lastUpdates = Collections.synchronizedMap(new HashMap());

    public DependencyServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService, ClassLoaderService classLoaderService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
        this.classLoaderService = classLoaderService;
    }

    private String getKey(ScopeType artifactType, long artifactId) {
        StringBuilder sb = new StringBuilder(artifactType.name());
        sb.append("________");
        sb.append(artifactId);
        return sb.toString();
    }

    private SDependencyLogBuilder getQueriableLog(ActionType actionType, String message) {
        SDependencyLogBuilder logBuilder = BuilderFactory.get(SDependencyLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    private SDependencyMappingLogBuilder getQueriableLog(ActionType actionType, String message, SDependencyMapping dependencyMapping) {
        SDependencyMappingLogBuilder logBuilder = BuilderFactory.get(SDependencyMappingLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        logBuilder.dependencyId(dependencyMapping.getDependencyId());
        logBuilder.objectId(dependencyMapping.getId());
        return logBuilder;
    }

    @Override
    public void createDependency(SDependency dependency) throws SDependencyCreationException {
        SDependencyLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a dependency with name " + dependency.getName());
        NullCheckingUtil.checkArgsNotNull(dependency);
        try {
            InsertRecord insertRecord = new InsertRecord(dependency);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("DEPENDENCY", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("DEPENDENCY").setObject(dependency).done();
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createDependency"));
            }
            this.initiateLogBuilder(dependency.getId(), 1, logBuilder, "createDependency");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(dependency.getId(), 0, logBuilder, "createDependency");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createDependency", e));
            }
            throw new SDependencyCreationException("Can't create dependency " + dependency, e);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Created dependency " + dependency);
        }
    }

    @Override
    public void createDependencyMapping(SDependencyMapping dependencyMapping) throws SDependencyException {
        SDependencyMappingLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a dependency mapping", dependencyMapping);
        NullCheckingUtil.checkArgsNotNull(dependencyMapping);
        try {
            InsertRecord insertRecord = new InsertRecord(dependencyMapping);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("DEPENDENCYMAPPING", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("DEPENDENCYMAPPING").setObject(dependencyMapping).done();
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(dependencyMapping.getId(), 1, logBuilder, "createDependencyMapping");
            this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), System.currentTimeMillis());
            this.refreshLocalClassLoader(dependencyMapping);
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(dependencyMapping.getId(), 0, logBuilder, "createDependencyMapping");
            throw new SDependencyException("Can't create dependency mapping" + dependencyMapping, e);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Created dependency mapping " + dependencyMapping);
        }
    }

    @Override
    public void deleteAllDependencies() throws SDependencyDeletionException {
        List<SDependency> dependencies;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteAllDependencies"));
        }
        QueryOptions queryOptions = new QueryOptions(0, 100, SDependency.class, "id", OrderByType.ASC);
        do {
            try {
                dependencies = this.getDependencies(queryOptions);
            }
            catch (SDependencyException e) {
                throw new SDependencyDeletionException(e);
            }
            for (SDependency dependency : dependencies) {
                this.deleteDependency(dependency);
            }
        } while (dependencies.size() == queryOptions.getNumberOfResults());
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteAllDependencies"));
        }
    }

    @Override
    public void deleteAllDependencyMappings() throws SDependencyException {
        List<SDependencyMapping> dependencyMappings;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteAllDependencyMappings"));
        }
        QueryOptions queryOptions = new QueryOptions(0, 100, SDependencyMapping.class, "id", OrderByType.ASC);
        do {
            dependencyMappings = this.getDependencyMappings(queryOptions);
            for (SDependencyMapping dependencyMapping : dependencyMappings) {
                this.deleteDependencyMapping(dependencyMapping);
            }
        } while (dependencyMappings.size() == queryOptions.getNumberOfResults());
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteAllDependencyMappings"));
        }
    }

    @Override
    public void deleteDependency(SDependency dependency) throws SDependencyDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Deleting dependency " + dependency);
        }
        NullCheckingUtil.checkArgsNotNull(dependency);
        SDependencyLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting a dependency named " + dependency.getName());
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("DEPENDENCY", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("DEPENDENCY").setObject(dependency).done();
        }
        try {
            DeleteRecord record = new DeleteRecord(dependency);
            this.recorder.recordDelete(record, deleteEvent);
            this.initiateLogBuilder(dependency.getId(), 1, logBuilder, "deleteDependency");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(dependency.getId(), 0, logBuilder, "deleteDependency");
            throw new SDependencyDeletionException("Can't delete dependency" + dependency, e);
        }
    }

    @Override
    public void deleteDependency(long id) throws SDependencyNotFoundException, SDependencyDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteDependency"));
        }
        NullCheckingUtil.checkArgsNotNull(id);
        this.deleteDependency(this.getDependency(id));
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteDependency"));
        }
    }

    @Override
    public void deleteDependency(String name) throws SDependencyNotFoundException, SDependencyDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteDependency"));
        }
        SDependency dependency = this.getDependencyByName(name);
        try {
            this.delete(dependency);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteDependency"));
            }
        }
        catch (SDependencyException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteDependency", e));
            }
            throw new SDependencyDeletionException("Can't delete dependency with name: " + name, e);
        }
    }

    private SDependency getDependencyByName(String name) throws SDependencyNotFoundException {
        Map<String, Object> parameters = Collections.singletonMap("name", name);
        SelectOneDescriptor desc = new SelectOneDescriptor("getDependencyByName", parameters, SDependency.class);
        try {
            SDependency sDependency = (SDependency)this.persistenceService.selectOne(desc);
            if (sDependency == null) {
                throw new SDependencyNotFoundException("Dependency with name " + name + " does not exist.");
            }
            return sDependency;
        }
        catch (SBonitaReadException sbre) {
            throw new SDependencyNotFoundException(sbre);
        }
    }

    @Override
    public void deleteDependencyMapping(long id) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteDependencyMapping"));
        }
        NullCheckingUtil.checkArgsNotNull(id);
        SDependencyMapping dependencyMapping = this.getDependencyMapping(id);
        this.deleteDependencyMapping(dependencyMapping);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteDependencyMapping"));
        }
    }

    @Override
    public void deleteDependencyMapping(SDependencyMapping dependencyMapping) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Deleting dependency mapping " + dependencyMapping);
        }
        NullCheckingUtil.checkArgsNotNull(dependencyMapping);
        SDependencyMappingLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting a dependency mapping", dependencyMapping);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("DEPENDENCYMAPPING", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("DEPENDENCYMAPPING").setObject(dependencyMapping).done();
        }
        try {
            DeleteRecord deleteRecord = new DeleteRecord(dependencyMapping);
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(dependencyMapping.getId(), 1, logBuilder, "deleteDependencyMapping");
            this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), System.currentTimeMillis());
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteDependencyMapping"));
            }
            this.refreshLocalClassLoader(dependencyMapping);
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteDependencyMapping", e));
            }
            this.initiateLogBuilder(dependencyMapping.getId(), 0, logBuilder, "deleteDependencyMapping");
            throw new SDependencyException("Can't delete dependency mapping" + dependencyMapping, e);
        }
    }

    @Override
    public List<SDependency> getDependencies(QueryOptions queryOptions) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependencies"));
        }
        NullCheckingUtil.checkArgsNotNull(queryOptions);
        try {
            List<SDependency> listSDependency = this.persistenceService.selectList(new SelectListDescriptor("getDependencies", null, SDependency.class, queryOptions));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependencies"));
            }
            return listSDependency;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependencies", e));
            }
            throw new SDependencyException("Can't get dependencies", e);
        }
    }

    @Override
    public List<SDependency> getDependencies(Collection<Long> ids) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependencies"));
        }
        NullCheckingUtil.checkArgsNotNull(ids);
        try {
            SelectListDescriptor desc = new SelectListDescriptor("getDependenciesByIds", CollectionUtil.buildSimpleMap("ids", ids), SDependency.class, QueryOptions.countQueryOptions());
            List<SDependency> listSDependency = this.persistenceService.selectList(desc);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependencies"));
            }
            return listSDependency;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependencies", e));
            }
            throw new SDependencyException("Can't get dependencies", e);
        }
    }

    @Override
    public SDependency getDependency(long id) throws SDependencyNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependency"));
        }
        NullCheckingUtil.checkArgsNotNull(id);
        try {
            SelectByIdDescriptor<SDependency> desc = new SelectByIdDescriptor<SDependency>("getDependencyById", SDependency.class, id);
            SDependency sDependency = this.persistenceService.selectById(desc);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependency"));
            }
            if (sDependency == null) {
                throw new SDependencyNotFoundException("Can't get dependency with id: " + id);
            }
            return sDependency;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependency", e));
            }
            throw new SDependencyNotFoundException("Can't get dependency with id: " + id, e);
        }
    }

    @Override
    public List<Long> getDependencyIds(long artifactId, ScopeType artifactType, int startIndex, int maxResult) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependencyIds"));
        }
        NullCheckingUtil.checkArgsNotNull(new Object[]{artifactId, artifactType, startIndex, maxResult});
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResult);
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("artifactId", artifactId);
            parameters.put("artifactType", (Object)artifactType);
            SelectListDescriptor<Long> desc = new SelectListDescriptor<Long>("getDependencyIds", parameters, SDependencyMapping.class, Long.class, queryOptions);
            List<Long> listIds = this.persistenceService.selectList(desc);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependencyIds"));
            }
            return listIds;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependencyIds", e));
            }
            throw new SDependencyException("Can't get dependencies", e);
        }
    }

    @Override
    public SDependencyMapping getDependencyMapping(long id) throws SDependencyMappingNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependencyMapping"));
        }
        NullCheckingUtil.checkArgsNotNull(id);
        try {
            SelectByIdDescriptor<SDependencyMapping> desc = new SelectByIdDescriptor<SDependencyMapping>("getDependencyMapping", SDependencyMapping.class, id);
            SDependencyMapping sDependencyMapping = this.persistenceService.selectById(desc);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependencyMapping"));
            }
            if (sDependencyMapping == null) {
                throw new SDependencyMappingNotFoundException("Can't get dependency mapping with id: " + id);
            }
            return sDependencyMapping;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependencyMapping", e));
            }
            throw new SDependencyMappingNotFoundException("Can't get dependency mapping with id: " + id, e);
        }
    }

    @Override
    public List<SDependencyMapping> getDependencyMappings(QueryOptions queryOptions) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependencyMappings"));
        }
        NullCheckingUtil.checkArgsNotNull(queryOptions);
        try {
            List<SDependencyMapping> listSDependencyMapping = this.persistenceService.selectList(new SelectListDescriptor("getDependencyMappings", null, SDependencyMapping.class, queryOptions));
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependencyMappings"));
            }
            return listSDependencyMapping;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependencyMappings", e));
            }
            throw new SDependencyException("Can't get dependency mappings", e);
        }
    }

    @Override
    public List<SDependencyMapping> getDependencyMappings(long dependencyId, QueryOptions queryOptions) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDependencyMappings"));
        }
        NullCheckingUtil.checkArgsNotNull(dependencyId, queryOptions);
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("dependencyId", dependencyId);
            SelectListDescriptor desc = new SelectListDescriptor("getDependencyMappingsByDependency", parameters, SDependencyMapping.class, queryOptions);
            List<SDependencyMapping> listSDependencyMapping = this.persistenceService.selectList(desc);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDependencyMappings"));
            }
            return listSDependencyMapping;
        }
        catch (SBonitaReadException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getDependencyMappings", e));
            }
            throw new SDependencyException("Can't get dependency mappings by dependencyId: " + dependencyId, e);
        }
    }

    @Override
    public long getLastUpdatedTimestamp(ScopeType artifactType, long artifactId) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getLastUpdatedTimestamp"));
        }
        NullCheckingUtil.checkArgsNotNull(new Object[]{artifactType, artifactId});
        String key = this.getKey(artifactType, artifactId);
        if (this.lastUpdates.containsKey(key)) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLastUpdatedTimestamp"));
            }
            return this.lastUpdates.get(key);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLastUpdatedTimestamp"));
        }
        return 0L;
    }

    @Override
    public void updateDependency(SDependency dependency, EntityUpdateDescriptor descriptor) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateDependency"));
        }
        NullCheckingUtil.checkArgsNotNull(dependency, descriptor);
        SDependencyLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Updating a dependency named " + dependency.getName());
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("DEPENDENCY", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("DEPENDENCY").setObject(dependency).done();
        }
        try {
            List<SDependencyMapping> dependencyMappings;
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)dependency, descriptor);
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(dependency.getId(), 1, logBuilder, "updateDependency");
            QueryOptions queryOptions = new QueryOptions(0, 100, SDependencyMapping.class, "id", OrderByType.ASC);
            long updateTimeStamp = System.currentTimeMillis();
            do {
                dependencyMappings = this.getDependencyMappings(dependency.getId(), queryOptions);
                for (SDependencyMapping dependencyMapping : dependencyMappings) {
                    this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), updateTimeStamp);
                    this.refreshLocalClassLoader(dependencyMapping);
                }
                queryOptions = QueryOptions.getNextPage(queryOptions);
            } while (dependencyMappings.size() == queryOptions.getNumberOfResults());
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateDependency"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateDependency", e));
            }
            this.initiateLogBuilder(dependency.getId(), 0, logBuilder, "updateDependency");
            throw new SDependencyException("Can't update dependency " + dependency, e);
        }
    }

    @Override
    public void updateDependencyMapping(SDependencyMapping dependencyMapping, EntityUpdateDescriptor descriptor) throws SDependencyException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "updateDependencyMapping"));
        }
        NullCheckingUtil.checkArgsNotNull(dependencyMapping, descriptor);
        SDependencyMappingLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Updating a dependency mapping", dependencyMapping);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("DEPENDENCYMAPPING", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("DEPENDENCYMAPPING").setObject(dependencyMapping).done();
        }
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)dependencyMapping, descriptor);
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(dependencyMapping.getId(), 1, logBuilder, "updateDependencyMapping");
            this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), System.currentTimeMillis());
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "updateDependencyMapping"));
            }
            this.refreshLocalClassLoader(dependencyMapping);
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "updateDependencyMapping", e));
            }
            this.initiateLogBuilder(dependencyMapping.getId(), 0, logBuilder, "updateDependencyMapping");
            throw new SDependencyException("Can't update dependency mapping " + dependencyMapping, e);
        }
    }

    @Override
    public List<SDependencyMapping> removeDisconnectedDependencyMappings(ArtifactAccessor artifactAccessor) throws SDependencyException {
        List<SDependencyMapping> dependencyMappings;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeDisconnectedDependencyMappings"));
        }
        QueryOptions loopQueryOptions = new QueryOptions(0, 100, SDependencyMapping.class, "id", OrderByType.ASC);
        ArrayList<SDependencyMapping> result = new ArrayList<SDependencyMapping>();
        do {
            dependencyMappings = this.getDependencyMappings(loopQueryOptions);
            for (SDependencyMapping dependencyMapping : dependencyMappings) {
                if (artifactAccessor.artifactExists(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId())) continue;
                result.add(dependencyMapping);
                this.deleteDependencyMapping(dependencyMapping);
            }
            loopQueryOptions = QueryOptions.getNextPage(loopQueryOptions);
        } while (dependencyMappings.size() == loopQueryOptions.getNumberOfResults());
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeDisconnectedDependencyMappings"));
        }
        return result;
    }

    @Override
    public List<SDependencyMapping> getDisconnectedDependencyMappings(ArtifactAccessor artifactAccessor, QueryOptions queryOptions) throws SDependencyException {
        List<SDependencyMapping> dependencyMappings;
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getDisconnectedDependencyMappings"));
        }
        ArrayList<SDependencyMapping> result = new ArrayList<SDependencyMapping>();
        int numberOfResultsFound = 0;
        int startIndex = queryOptions.getFromIndex();
        int numberOfResults = queryOptions.getNumberOfResults();
        QueryOptions loopQueryOptions = new QueryOptions(queryOptions);
        do {
            dependencyMappings = this.getDependencyMappings(loopQueryOptions);
            for (SDependencyMapping dependencyMapping : dependencyMappings) {
                if (artifactAccessor.artifactExists(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId())) continue;
                if (++numberOfResultsFound > startIndex) {
                    result.add(dependencyMapping);
                }
                if (result.size() != numberOfResults) continue;
                break;
            }
            loopQueryOptions = QueryOptions.getNextPage(loopQueryOptions);
        } while (dependencyMappings.size() == numberOfResults && result.size() < numberOfResults);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getDisconnectedDependencyMappings"));
        }
        return result;
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }

    @Override
    public void deleteDependencies(long id, ScopeType type) throws SDependencyException, SDependencyNotFoundException, SDependencyDeletionException {
        QueryOptions queryOptionsForMapping = new QueryOptions(0, 2, SDependencyMapping.class, "id", OrderByType.ASC);
        int fromIndex = 0;
        List<Long> dependencyIds = this.getDependencyIds(id, type, fromIndex, 100);
        while (!dependencyIds.isEmpty()) {
            for (Long dependencyId : dependencyIds) {
                List<SDependencyMapping> dependencyMappings = this.getDependencyMappings(dependencyId, queryOptionsForMapping);
                if (dependencyMappings.size() == 1) {
                    SDependencyMapping dependencyMapping = dependencyMappings.get(0);
                    this.deleteDependencyMapping(dependencyMapping);
                    this.deleteDependency(dependencyId);
                    continue;
                }
                ++fromIndex;
            }
            dependencyIds = this.getDependencyIds(id, type, fromIndex, 100);
        }
    }

    private void refreshLocalClassLoader(SDependencyMapping dependencyMapping) throws SDependencyException {
        this.refreshClassLoader(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId());
    }

    private Map<String, byte[]> getDependenciesResources(ScopeType type, long id) throws SDependencyException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        int fromIndex = 0;
        List<Long> dependencyIds = null;
        do {
            if ((dependencyIds = this.getDependencyIds(id, type, fromIndex, 100)) != null && dependencyIds.size() > 0) {
                List<SDependency> dependencies = this.getDependencies(dependencyIds);
                for (SDependency dependency : dependencies) {
                    resources.put(dependency.getFileName(), dependency.getValue());
                }
            }
            fromIndex += 100;
        } while (dependencyIds.size() == 100);
        return resources;
    }

    @Override
    public void refreshClassLoader(ScopeType type, long id) throws SDependencyException {
        Map<String, byte[]> resources = this.getDependenciesResources(type, id);
        try {
            this.classLoaderService.refreshLocalClassLoader(type.name(), id, resources);
        }
        catch (SClassLoaderException e) {
            throw new SDependencyException("Cannot refresh classLoader with type'" + (Object)((Object)type) + "' and id " + id, e);
        }
    }

    @Override
    public void updateDependenciesOfArtifact(long id, ScopeType type, List<SDependency> dependencies) throws SDependencyException {
        Map<String, SDependency> newDependenciesByName = this.getMapOfNames(dependencies);
        int fromIndex = 0;
        List<Long> dependencyIds = this.getDependencyIds(id, type, fromIndex, 100);
        while (!dependencyIds.isEmpty()) {
            List<SDependency> currentDependencies = this.getDependencies(dependencyIds);
            for (SDependency currentDependency : currentDependencies) {
                if (!newDependenciesByName.containsKey(currentDependency.getName())) {
                    this.delete(currentDependency);
                } else {
                    SDependency newDependency = newDependenciesByName.get(currentDependency.getName());
                    this.update(currentDependency, newDependency);
                }
                newDependenciesByName.remove(currentDependency.getName());
            }
            dependencyIds = this.getDependencyIds(id, type, fromIndex += 100, 100);
        }
        for (SDependency sDependency : newDependenciesByName.values()) {
            this.createForArtifact(id, type, sDependency);
        }
    }

    private void createForArtifact(long id, ScopeType type, SDependency sDependency) throws SDependencyCreationException, SDependencyException {
        this.createDependency(sDependency);
        SDependencyMapping sDependencyMapping = BuilderFactory.get(SDependencyMappingBuilderFactory.class).createNewInstance(sDependency.getId(), id, type).done();
        this.createDependencyMapping(sDependencyMapping);
    }

    private void update(SDependency currentDependency, SDependency newDependency) throws SDependencyException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SDependencyBuilderFactory.class).getDescriptionKey(), newDependency.getDescription());
        descriptor.addField(BuilderFactory.get(SDependencyBuilderFactory.class).getFileNameKey(), newDependency.getFileName());
        descriptor.addField(BuilderFactory.get(SDependencyBuilderFactory.class).getValueKey(), newDependency.getValue());
        this.updateDependency(currentDependency, descriptor);
    }

    private void delete(SDependency dependency) throws SDependencyException, SDependencyDeletionException {
        QueryOptions queryOptions = new QueryOptions(0, 10, SDependencyMapping.class, "id", OrderByType.ASC);
        SDependencyMapping sDependencyMapping = this.getDependencyMappings(dependency.getId(), queryOptions).get(0);
        this.deleteDependencyMapping(sDependencyMapping);
        this.deleteDependency(dependency);
    }

    private Map<String, SDependency> getMapOfNames(List<SDependency> dependencies) {
        HashMap<String, SDependency> hashMap = new HashMap<String, SDependency>(dependencies.size());
        for (SDependency sDependency : dependencies) {
            hashMap.put(sDependency.getName(), sDependency);
        }
        return hashMap;
    }
}

