/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.xml.SInvalidSchemaException;
import org.bonitasoft.engine.xml.XMLNode;
import org.bonitasoft.engine.xml.XMLSchemaValidator;
import org.bonitasoft.engine.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMWriter
implements XMLWriter {
    private static final String ENCODING = "UTF-8";
    private final Transformer transformer;
    private final DocumentBuilder documentBuilder;
    private final XMLSchemaValidator validator;
    private Source xsdSource;

    public DOMWriter(XMLSchemaValidator validator) throws TransformerConfigurationException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.transformer = transformerFactory.newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        this.transformer.setOutputProperty("encoding", ENCODING);
        this.validator = validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] write(XMLNode rootNode) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] xmlContent = null;
        try {
            this.write(rootNode, outputStream);
            xmlContent = outputStream.toByteArray();
        }
        catch (IOException e) {
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {}
        }
        return xmlContent;
    }

    @Override
    public void write(XMLNode rootNode, Writer writer) {
        try {
            StreamResult sr = new StreamResult(writer);
            this.write(rootNode, sr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(XMLNode rootNode, OutputStream outputStream) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(outputStream, ENCODING);
            this.write(rootNode, osw);
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }

    private void write(XMLNode rootNode, StreamResult result) throws TransformerException {
        Document document = this.getDocument(rootNode);
        DOMSource source = new DOMSource(document);
        this.transformer.transform(source, result);
    }

    private Document getDocument(XMLNode rootNode) {
        Document document = this.documentBuilder.newDocument();
        document.setXmlVersion("1.0");
        document.setXmlStandalone(true);
        Node root = this.addNode(document, null, rootNode);
        document.appendChild(root);
        return document;
    }

    private Node addNode(Document document, Node parentNode, XMLNode node) {
        String name = node.getName();
        Map<String, String> attributes = node.getAttributes();
        String content = node.getContent();
        Element element = document.createElement(name);
        if (content != null) {
            element.setTextContent(content);
        }
        if (attributes != null) {
            for (Map.Entry entry : attributes.entrySet()) {
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                if (attributeValue == null) continue;
                element.setAttribute(attributeName, attributeValue);
            }
        }
        for (XMLNode xMLNode : node.getChildNodes()) {
            Node child = this.addNode(document, element, xMLNode);
            element.appendChild(child);
        }
        if (parentNode == null) {
            return element;
        }
        return parentNode.appendChild(element);
    }

    @Override
    public void setSchema(File xsdSchema) throws SInvalidSchemaException {
        InputStream openStream = null;
        try {
            openStream = xsdSchema.toURI().toURL().openStream();
            this.validator.setSchema(new StreamSource(openStream));
        }
        catch (Exception e) {
            throw new SBonitaRuntimeException(e);
        }
        finally {
            try {
                openStream.close();
            }
            catch (IOException e) {
                throw new SBonitaRuntimeException(e);
            }
        }
    }
}

