/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.platform;

import org.bonitasoft.engine.command.PlatformCommand;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;

public class GetPlatformCommand
implements TransactionContentWithResult<PlatformCommand> {
    private final String platformCommandClassName;
    private PlatformCommand command;

    public GetPlatformCommand(String platformCommandClassName) {
        this.platformCommandClassName = platformCommandClassName;
    }

    @Override
    public void execute() throws SBonitaException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            this.command = (PlatformCommand)contextClassLoader.loadClass(this.platformCommandClassName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new SCommandParameterizationException(cnfe);
        }
        catch (InstantiationException ie) {
            throw new SCommandParameterizationException(ie);
        }
        catch (IllegalAccessException iae) {
            throw new SCommandParameterizationException(iae);
        }
    }

    @Override
    public PlatformCommand getResult() {
        return this.command;
    }
}

