/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.archive.impl;

import org.bonitasoft.engine.archive.impl.BatchArchiveCallable;
import org.bonitasoft.engine.commons.exceptions.SBonitaRuntimeException;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionState;

public class BatchArchiveSynchronization
implements BonitaTransactionSynchronization {
    private final PersistenceService persistenceService;
    private final BatchArchiveCallable batchArchiveCallable;

    public BatchArchiveSynchronization(PersistenceService persistenceService, BatchArchiveCallable batchArchiveCallable) {
        this.persistenceService = persistenceService;
        this.batchArchiveCallable = batchArchiveCallable;
    }

    @Override
    public void afterCompletion(TransactionState status) {
    }

    @Override
    public void beforeCommit() {
        if (this.batchArchiveCallable.hasObjects()) {
            try {
                this.batchArchiveCallable.call();
                this.persistenceService.flushStatements();
            }
            catch (Exception e) {
                throw new SBonitaRuntimeException(e);
            }
        }
    }
}

