/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.identity.mapping.impl;

import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.external.identity.mapping.ExternalIdentityMappingService;
import org.bonitasoft.engine.external.identity.mapping.SExternalIdentityMappingCreationException;
import org.bonitasoft.engine.external.identity.mapping.SExternalIdentityMappingDeletionException;
import org.bonitasoft.engine.external.identity.mapping.SExternalIdentityMappingNotFoundException;
import org.bonitasoft.engine.external.identity.mapping.impl.SelectDescriptorBuilder;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMapping;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMappingLogBuilder;
import org.bonitasoft.engine.external.identity.mapping.model.SExternalIdentityMappingLogBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class ExternalIdentityMappingServiceImpl
implements ExternalIdentityMappingService {
    private static final String EXTERNAL_IDENTITY_MAPPING = "EXTERNAL_IDENTITY_MAPPING";
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;

    public ExternalIdentityMappingServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
    }

    @Override
    public SExternalIdentityMapping createExternalIdentityMapping(SExternalIdentityMapping externalIdentityMapping) throws SExternalIdentityMappingCreationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "createExternalIdentityMapping"));
        }
        SExternalIdentityMappingLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Adding a new ExternalIdentityMapping for external id " + externalIdentityMapping.getExternalId());
        try {
            InsertRecord insertRecord = new InsertRecord(externalIdentityMapping);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers(EXTERNAL_IDENTITY_MAPPING, EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent(EXTERNAL_IDENTITY_MAPPING).setObject(externalIdentityMapping).done();
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(externalIdentityMapping.getId(), 1, logBuilder, "createExternalIdentityMapping");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "createExternalIdentityMapping"));
            }
            return externalIdentityMapping;
        }
        catch (SRecorderException re) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "createExternalIdentityMapping", re));
            }
            this.initiateLogBuilder(externalIdentityMapping.getId(), 0, logBuilder, "createExternalIdentityMapping");
            throw new SExternalIdentityMappingCreationException(re);
        }
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingById(long mappingId) throws SExternalIdentityMappingNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getExternalIdentityMappingById"));
        }
        SelectByIdDescriptor<SExternalIdentityMapping> selectByIdDescriptor = SelectDescriptorBuilder.getExternalIdentityMappingById(mappingId);
        try {
            SExternalIdentityMapping mapping = this.persistenceService.selectById(selectByIdDescriptor);
            if (mapping == null) {
                throw new SExternalIdentityMappingNotFoundException(mappingId + " does not refer to any external identity mapping");
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getExternalIdentityMappingById"));
            }
            return mapping;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getExternalIdentityMappingById", bre));
            }
            throw new SExternalIdentityMappingNotFoundException(bre);
        }
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingForUser(long mappingId) throws SExternalIdentityMappingNotFoundException {
        return this.getExternalIdentityMappingById(mappingId, "ForUser", "user");
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingById(long mappingId, String suffix, String messageSuffix) throws SExternalIdentityMappingNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getExternalIdentityMappingById"));
        }
        SelectByIdDescriptor<SExternalIdentityMapping> selectByIdDescriptor = SelectDescriptorBuilder.getExternalIdentityMappingById(mappingId, suffix);
        try {
            SExternalIdentityMapping externalIdentityMapping = this.persistenceService.selectById(selectByIdDescriptor);
            if (externalIdentityMapping == null) {
                throw new SExternalIdentityMappingNotFoundException(mappingId + " does not refer to any external identity mapping associated to a " + messageSuffix);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getExternalIdentityMappingById"));
            }
            return externalIdentityMapping;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getExternalIdentityMappingById", bre));
            }
            throw new SExternalIdentityMappingNotFoundException(bre);
        }
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingForGroup(long mappingId) throws SExternalIdentityMappingNotFoundException {
        return this.getExternalIdentityMappingById(mappingId, "ForGroup", "group");
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingForRole(long mappingId) throws SExternalIdentityMappingNotFoundException {
        return this.getExternalIdentityMappingById(mappingId, "ForRole", "role");
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingForRoleAndGroup(long mappingId) throws SExternalIdentityMappingNotFoundException {
        return this.getExternalIdentityMappingById(mappingId, "ForRoleAndGroup", "role and group");
    }

    @Override
    public void deleteExternalIdentityMapping(long mappingId) throws SExternalIdentityMappingNotFoundException, SExternalIdentityMappingDeletionException {
        SExternalIdentityMapping sExternalIdentityMapping = this.getExternalIdentityMappingWithoutDisplayName(mappingId);
        this.deleteExternalIdentityMapping(sExternalIdentityMapping);
    }

    @Override
    public void deleteExternalIdentityMapping(SExternalIdentityMapping externalIdentityMapping) throws SExternalIdentityMappingDeletionException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "deleteExternalIdentityMapping"));
        }
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers(EXTERNAL_IDENTITY_MAPPING, EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent(EXTERNAL_IDENTITY_MAPPING).setObject(externalIdentityMapping).done();
        }
        DeleteRecord record = new DeleteRecord(externalIdentityMapping);
        SExternalIdentityMappingLogBuilder queriableLog = this.getQueriableLog(ActionType.DELETED, "deleting external identity mapping");
        try {
            this.recorder.recordDelete(record, deleteEvent);
            this.initiateLogBuilder(externalIdentityMapping.getId(), 1, queriableLog, "deleteExternalIdentityMapping");
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "deleteExternalIdentityMapping"));
            }
        }
        catch (SRecorderException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "deleteExternalIdentityMapping", e));
            }
            this.initiateLogBuilder(externalIdentityMapping.getId(), 0, queriableLog, "deleteExternalIdentityMapping");
            throw new SExternalIdentityMappingDeletionException("Can't delete process external identity mapping " + externalIdentityMapping, e);
        }
    }

    @Override
    public void deleteAllExternalIdentityMappings() throws SExternalIdentityMappingDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SExternalIdentityMapping.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SExternalIdentityMappingDeletionException("Can't delete all process external identity mappings ", e);
        }
    }

    private SExternalIdentityMappingLogBuilder getQueriableLog(ActionType actionType, String message) {
        SExternalIdentityMappingLogBuilder logBuilder = BuilderFactory.get(SExternalIdentityMappingLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public long getNumberOfExternalIdentityMappingsForUser(String kind, long userId, String externalId, QueryOptions searchOptions, String querySuffix) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfExternalIdentityMappingsForUser"));
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("kind", kind);
            parameters.put("userId", userId);
            parameters.put("externalId", externalId);
            long number = this.persistenceService.getNumberOfEntities(SExternalIdentityMapping.class, querySuffix, searchOptions, parameters);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfExternalIdentityMappingsForUser"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfExternalIdentityMappingsForUser", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SExternalIdentityMapping> searchExternalIdentityMappingsForUser(String kind, long userId, String externalId, QueryOptions queryOptions, String querySuffix) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchExternalIdentityMappingsForUser"));
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("kind", kind);
            parameters.put("userId", userId);
            parameters.put("externalId", externalId);
            List<SExternalIdentityMapping> listSExternalIdentityMapping = this.persistenceService.searchEntity(SExternalIdentityMapping.class, querySuffix, queryOptions, parameters);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchExternalIdentityMappingsForUser"));
            }
            return listSExternalIdentityMapping;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchExternalIdentityMappingsForUser", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfExternalIdentityMappings(String kind, QueryOptions searchOptions, String querySuffix) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getNumberOfExternalIdentityMappings"));
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put("kind", kind);
            long number = this.persistenceService.getNumberOfEntities(SExternalIdentityMapping.class, querySuffix, searchOptions, parameters);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getNumberOfExternalIdentityMappings"));
            }
            return number;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getNumberOfExternalIdentityMappings", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SExternalIdentityMapping> searchExternalIdentityMappings(String kind, QueryOptions queryOptions, String querySuffix) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchExternalIdentityMappings"));
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put("kind", kind);
            List<SExternalIdentityMapping> listSExternalIdentityMappings = this.persistenceService.searchEntity(SExternalIdentityMapping.class, querySuffix, queryOptions, parameters);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchExternalIdentityMappings"));
            }
            return listSExternalIdentityMappings;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchExternalIdentityMappings", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SExternalIdentityMapping> searchExternalIdentityMappings(String kind, String externalId, QueryOptions queryOptions) throws SBonitaSearchException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "searchExternalIdentityMappings"));
        }
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put("kind", kind);
            parameters.put("externalId", externalId);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "searchExternalIdentityMappings"));
            }
            return this.persistenceService.searchEntity(SExternalIdentityMapping.class, null, queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "searchExternalIdentityMappings", bre));
            }
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public SExternalIdentityMapping getExternalIdentityMappingWithoutDisplayName(long mappingId) throws SExternalIdentityMappingNotFoundException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getExternalIdentityMappingWithoutDisplayName"));
        }
        SelectByIdDescriptor<SExternalIdentityMapping> selectByIdDescriptor = SelectDescriptorBuilder.getExternalIdentityMappingById(mappingId);
        try {
            SExternalIdentityMapping mapping = this.persistenceService.selectById(selectByIdDescriptor);
            if (mapping == null) {
                throw new SExternalIdentityMappingNotFoundException(mappingId + " does not refer to any external identity mapping");
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getExternalIdentityMappingWithoutDisplayName"));
            }
            return mapping;
        }
        catch (SBonitaReadException bre) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getExternalIdentityMappingWithoutDisplayName", bre));
            }
            throw new SExternalIdentityMappingNotFoundException(bre);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }
}

