/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.jobs;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.jobs.InternalJob;
import org.bonitasoft.engine.scheduler.exception.SJobExecutionException;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.session.SessionService;

public class CleanInvalidSessionsJob
extends InternalJob {
    private static final long serialVersionUID = 2448120492184242153L;

    @Override
    public String getName() {
        return "CleanInvalidSessionsJob";
    }

    @Override
    public String getDescription() {
        return "Clean all invalid sessions";
    }

    @Override
    public void execute() throws SJobExecutionException {
        try {
            PlatformServiceAccessor platformServiceAccessor = ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
            SessionService sessionService = platformServiceAccessor.getSessionService();
            sessionService.cleanInvalidSessions();
        }
        catch (Exception e) {
            throw new SJobExecutionException("Unable to clean invalid sessions", e);
        }
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) {
    }
}

