/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.jobs;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.event.trigger.SEventTriggerType;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.jobs.InternalJob;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SJobConfigurationException;
import org.bonitasoft.engine.scheduler.exception.SJobExecutionException;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.UserTransactionService;
import org.bonitasoft.engine.work.WorkService;

public class TriggerTimerEventJob
extends InternalJob {
    private static final long serialVersionUID = 8727861254645155327L;
    private transient EventsHandler eventsHandler;
    private Long processDefinitionId;
    private long targetSFlowNodeDefinitionId;
    private Long flowNodeInstanceId;
    private Long parentProcessInstanceId;
    private Long rootProcessInstanceId;
    private String containerType;
    private String eventType;
    private Boolean isInterrupting;
    private Long subProcessId;
    private transient WorkService workService;
    private transient JobService jobService;
    private transient SchedulerService schedulerService;
    private transient TechnicalLoggerService loggerService;
    private Long jobDescriptorId;
    private UserTransactionService transactionService;

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void execute() throws SJobExecutionException {
        try {
            if (this.workService.isStopped()) {
                block7: {
                    this.loggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "Rescheduling Timer job " + this.jobDescriptorId + " because the work service was shutdown. the timer is in process definition " + this.processDefinitionId + " on definition element " + this.targetSFlowNodeDefinitionId);
                    try {
                        SJobDescriptor sJobDescriptor = this.jobService.getJobDescriptor(this.jobDescriptorId);
                        this.schedulerService.executeAgain(sJobDescriptor.getId());
                    }
                    catch (SBonitaException sbe) {
                        if (!this.loggerService.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) break block7;
                        this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "Unable to reschedule the job: " + this.jobDescriptorId, sbe);
                    }
                }
                return;
            }
            if (this.subProcessId == null) {
                this.eventsHandler.triggerCatchEvent(this.eventType, this.processDefinitionId, this.targetSFlowNodeDefinitionId, this.flowNodeInstanceId, this.containerType);
            } else {
                this.eventsHandler.triggerCatchEvent(SEventTriggerType.TIMER, this.processDefinitionId, this.targetSFlowNodeDefinitionId, this.containerType, this.subProcessId, this.parentProcessInstanceId, this.rootProcessInstanceId, this.isInterrupting);
            }
        }
        catch (SBonitaException e) {
            throw new SJobExecutionException(e);
        }
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) throws SJobConfigurationException {
        this.processDefinitionId = (Long)attributes.get("processDefinitionId");
        this.targetSFlowNodeDefinitionId = (Long)attributes.get("targetSFlowNodeDefinitionId");
        this.flowNodeInstanceId = (Long)attributes.get("flowNodeInstanceId");
        this.containerType = (String)((Object)attributes.get("containerType"));
        this.eventType = (String)((Object)attributes.get("eventType"));
        this.subProcessId = (Long)attributes.get("subProcessId");
        this.parentProcessInstanceId = (Long)attributes.get("processInstanceId");
        this.rootProcessInstanceId = (Long)attributes.get("rootProcessInstanceId");
        this.isInterrupting = (Boolean)attributes.get("isInterrupting");
        TenantServiceAccessor tenantServiceAccessor = this.getTenantServiceAccessor();
        this.eventsHandler = tenantServiceAccessor.getEventsHandler();
        this.workService = tenantServiceAccessor.getWorkService();
        this.jobService = tenantServiceAccessor.getJobService();
        this.schedulerService = tenantServiceAccessor.getSchedulerService();
        this.loggerService = tenantServiceAccessor.getTechnicalLoggerService();
        this.transactionService = tenantServiceAccessor.getUserTransactionService();
        this.jobDescriptorId = (Long)attributes.get("JOB_DESCRIPTOR_ID");
    }
}

