/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.recorder.model;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.Record;

public final class UpdateRecord
extends Record {
    private Map<String, Object> fields;
    private final Object oldValue;

    private UpdateRecord(PersistentObject entity, Object oldValue) {
        super(entity);
        this.oldValue = oldValue;
    }

    public static UpdateRecord buildSetFields(PersistentObject entity, Map<String, Object> fields) {
        UpdateRecord updateRecord = new UpdateRecord(entity, null);
        updateRecord.addFields(fields);
        return updateRecord;
    }

    public static UpdateRecord buildSetFields(PersistentObject entity, EntityUpdateDescriptor descriptor) {
        NullCheckingUtil.checkArgsNotNull(descriptor);
        UpdateRecord updateRecord = new UpdateRecord(entity, null);
        updateRecord.addFields(descriptor.getFields());
        return updateRecord;
    }

    public static UpdateRecord buildSetField(PersistentObject entity, String fieldName, Object fieldValue, Object oldValue, String message, Enum<?> recordType, Long ... parentIds) {
        UpdateRecord updateRecord = new UpdateRecord(entity, oldValue);
        updateRecord.addField(fieldName, fieldValue);
        return updateRecord;
    }

    public void addField(String fieldName, Object fieldValue) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.put(fieldName, fieldValue);
    }

    public void addFields(Map<String, Object> fields) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.putAll(fields);
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }
}

