/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.supervisor;

import java.util.List;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;

public class SearchFlowNodeInstanceSupervisedBy
extends AbstractSearchEntity<FlowNodeInstance, SFlowNodeInstance> {
    private final FlowNodeInstanceService flowNodeInstanceService;
    private final FlowNodeStateManager flowNodeStateManager;
    private final Long supervisorId;

    public SearchFlowNodeInstanceSupervisedBy(Long supervisorId, FlowNodeInstanceService flowNodeInstanceService, FlowNodeStateManager flowNodeStateManager, SearchEntityDescriptor searchDescriptor, SearchOptions searchOptions) {
        super(searchDescriptor, searchOptions);
        this.supervisorId = supervisorId;
        this.flowNodeInstanceService = flowNodeInstanceService;
        this.flowNodeStateManager = flowNodeStateManager;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaSearchException {
        return this.flowNodeInstanceService.getNumberOfFlowNodeInstancesSupervisedBy(this.supervisorId, SFlowNodeInstance.class, searchOptions);
    }

    @Override
    public List<SFlowNodeInstance> executeSearch(QueryOptions searchOptions) throws SBonitaSearchException {
        return this.flowNodeInstanceService.searchFlowNodeInstancesSupervisedBy(this.supervisorId, SFlowNodeInstance.class, searchOptions);
    }

    @Override
    public List<FlowNodeInstance> convertToClientObjects(List<SFlowNodeInstance> serverObjects) {
        return ModelConvertor.toFlowNodeInstances(serverObjects, this.flowNodeStateManager);
    }
}

