/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.platform.PlatformService;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.SQueriableLogBuilderFactory;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.QueriableLogSessionProvider;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.services.QueriableLoggerStrategy;
import org.bonitasoft.engine.services.SQueriableLogException;
import org.bonitasoft.engine.services.SQueriableLogNotFoundException;

public abstract class AbstractQueriableLoggerImpl
implements QueriableLoggerService {
    private final PersistenceService persistenceService;
    private final QueriableLoggerStrategy loggerStrategy;
    private final QueriableLogSessionProvider sessionProvider;
    private final PlatformService platformService;

    public AbstractQueriableLoggerImpl(PersistenceService persistenceService, QueriableLoggerStrategy loggerStrategy, QueriableLogSessionProvider sessionProvider, PlatformService platformService) {
        NullCheckingUtil.checkArgsNotNull(persistenceService, loggerStrategy, sessionProvider);
        this.persistenceService = persistenceService;
        this.loggerStrategy = loggerStrategy;
        this.sessionProvider = sessionProvider;
        this.platformService = platformService;
    }

    @Override
    public int getNumberOfLogs() throws SQueriableLogException {
        Map<String, Object> emptyMap = Collections.emptyMap();
        try {
            Long read = this.persistenceService.selectOne(new SelectOneDescriptor<Long>("getNumberOfLogs", emptyMap, SQueriableLog.class, Long.class));
            return read.intValue();
        }
        catch (SBonitaReadException e) {
            throw this.handleError("can't get the number of log", e);
        }
    }

    @Override
    public List<SQueriableLog> getLogs(int startIndex, int maxResults, String field, OrderByType order) throws SQueriableLogException {
        List<SQueriableLog> logs;
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, SQueriableLog.class, field, order);
        try {
            logs = this.persistenceService.selectList(new SelectListDescriptor("getLogs", null, SQueriableLog.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw this.handleError("can't get logs", e);
        }
        return logs;
    }

    @Override
    public long getNumberOfLogs(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SQueriableLog.class, searchOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public List<SQueriableLog> searchLogs(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SQueriableLog.class, searchOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public void log(String callerClassName, String callerMethodName, SQueriableLog ... queriableLogs) {
        NullCheckingUtil.checkArgsNotNull(queriableLogs);
        ArrayList<SQueriableLog> loggableLogs = new ArrayList<SQueriableLog>();
        for (SQueriableLog log : queriableLogs) {
            if (!this.isLoggable(log.getActionType(), log.getSeverity())) continue;
            SQueriableLogBuilderFactory fact = BuilderFactory.get(SQueriableLogBuilderFactory.class);
            log = fact.fromInstance(log).callerClassName(callerClassName).callerMethodName(callerMethodName).userId(this.sessionProvider.getUserId()).clusterNode(this.sessionProvider.getClusterNode()).productVersion(this.platformService.getSPlatformProperties().getPlatformVersion()).done();
            loggableLogs.add(log);
        }
        if (loggableLogs.size() > 0) {
            this.log(loggableLogs);
        }
    }

    protected abstract void log(List<SQueriableLog> var1);

    @Override
    public boolean isLoggable(String actionType, SQueriableLogSeverity severity) {
        NullCheckingUtil.checkArgsNotNull(new Object[]{actionType, severity});
        return this.loggerStrategy.isLoggable(actionType, severity);
    }

    protected PersistenceService getPersitenceService() {
        return this.persistenceService;
    }

    protected QueriableLoggerStrategy getQueriableLogConfiguration() {
        return this.loggerStrategy;
    }

    @Override
    public SQueriableLog getLog(long logId) throws SQueriableLogNotFoundException, SQueriableLogException {
        try {
            SQueriableLog selectOne = this.persistenceService.selectById(new SelectByIdDescriptor<SQueriableLog>("getQueriableLogById", SQueriableLog.class, logId));
            if (selectOne == null) {
                throw new SQueriableLogNotFoundException(logId);
            }
            return selectOne;
        }
        catch (SBonitaReadException sbre) {
            throw new SQueriableLogException(sbre);
        }
    }

    private SQueriableLogException handleError(String message, Exception e) {
        if (e != null) {
            e.printStackTrace();
        }
        return new SQueriableLogException(message, e);
    }
}

