/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.synchro.jms.AbstractUpdateHandler;
import org.bonitasoft.engine.synchro.jms.PerfEventUtil;

public class TaskReadyHandler
extends AbstractUpdateHandler {
    private static final long serialVersionUID = 1L;
    private final String identifier = UUID.randomUUID().toString();

    public TaskReadyHandler(long tenantId, long messageTimeout) {
        super(tenantId, messageTimeout);
    }

    @Override
    protected Map<String, Serializable> getEvent(SEvent sEvent) {
        SFlowNodeInstance flowNodeInstance = (SFlowNodeInstance)sEvent.getObject();
        return PerfEventUtil.getReadyTaskEvent(flowNodeInstance.getRootContainerId(), flowNodeInstance.getName());
    }

    @Override
    public boolean isInterested(SEvent event) {
        if (event.getObject() instanceof SFlowNodeInstance) {
            SFlowNodeInstance fni = (SFlowNodeInstance)event.getObject();
            boolean interested = !fni.isStateExecuting();
            interested &= fni.getStateId() == 4;
            return interested &= fni.getType() == SFlowNodeType.USER_TASK || fni.getType() == SFlowNodeType.MANUAL_TASK;
        }
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

