/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class GroovyScriptExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    @Override
    public Object evaluate(SExpression expression, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        String expressionContent = expression.getContent();
        ClassLoader scriptClassLoader = Thread.currentThread().getContextClassLoader();
        String expressionName = expression.getName();
        try {
            GroovyShell shell = new GroovyShell(scriptClassLoader);
            Script script = shell.parse(expressionContent);
            Binding binding = new Binding(context);
            script.setBinding(binding);
            return script.evaluate(expressionContent);
        }
        catch (MissingPropertyException e) {
            String property = e.getProperty();
            StringBuilder builder = new StringBuilder("Expression ");
            builder.append(expressionName).append(" with content: ").append(expressionContent).append(" depends on ").append(property).append(" is neither defined in the script nor in dependencies");
            throw new SExpressionEvaluationException(builder.toString(), e, expressionName);
        }
        catch (GroovyRuntimeException e) {
            throw new SExpressionEvaluationException((Throwable)e, expressionName);
        }
        catch (Exception e) {
            throw new SExpressionEvaluationException("Script throws an exception" + expression, e, expressionName);
        }
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_READ_ONLY_SCRIPT_GROOVY;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> context, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionEvaluationException {
        ArrayList<Object> list = new ArrayList<Object>(expressions.size());
        for (SExpression expression : expressions) {
            list.add(this.evaluate(expression, context, resolvedExpressions, containerState));
        }
        return list;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return false;
    }
}

