/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.jobs;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.scheduler.JobService;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.model.SJobDescriptor;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionState;

public class ExecuteAgainJobSynchronization
implements BonitaTransactionSynchronization {
    private final String jobName;
    private final JobService jobService;
    private final SchedulerService schedulerService;
    private final TechnicalLoggerService loggerService;

    public ExecuteAgainJobSynchronization(String jobName, JobService jobService, SchedulerService schedulerService, TechnicalLoggerService loggerService) {
        this.jobName = jobName;
        this.jobService = jobService;
        this.schedulerService = schedulerService;
        this.loggerService = loggerService;
    }

    @Override
    public void beforeCommit() {
        block2: {
            ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
            filters.add(new FilterOption(SJobDescriptor.class, "jobName", this.jobName));
            QueryOptions queryOptions = new QueryOptions(0, 1, null, filters, null);
            try {
                List<SJobDescriptor> jobDescriptors = this.jobService.searchJobDescriptors(queryOptions);
                SJobDescriptor sJobDescriptor = jobDescriptors.get(0);
                this.schedulerService.executeAgain(sJobDescriptor.getId());
            }
            catch (SBonitaException sbe) {
                if (!this.loggerService.isLoggable(ExecuteAgainJobSynchronization.class, TechnicalLogSeverity.WARNING)) break block2;
                this.loggerService.log(ExecuteAgainJobSynchronization.class, TechnicalLogSeverity.WARNING, "Unable to reschedule the job: " + this.jobName, sbe);
            }
        }
    }

    @Override
    public void afterCompletion(TransactionState txState) {
    }
}

