/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro.jms;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.synchro.jms.AbstractUpdateHandler;
import org.bonitasoft.engine.synchro.jms.PerfEventUtil;

public class ProcessInstanceFinishedHandler
extends AbstractUpdateHandler {
    private static final long serialVersionUID = 1L;
    private final String identifier = UUID.randomUUID().toString();

    public ProcessInstanceFinishedHandler(long tenantId, long messageTimeout) {
        super(tenantId, messageTimeout);
    }

    @Override
    protected Map<String, Serializable> getEvent(SEvent sEvent) {
        SProcessInstance instance = (SProcessInstance)sEvent.getObject();
        return PerfEventUtil.getProcessInstanceFinishedEvent(instance.getId());
    }

    @Override
    public boolean isInterested(SEvent event) {
        Object object = event.getObject();
        if (object instanceof SProcessInstance) {
            SProcessInstance pi = (SProcessInstance)event.getObject();
            return pi.getStateId() == ProcessInstanceState.COMPLETED.getId();
        }
        return false;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

