/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.List;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.api.impl.resolver.ActorProcessDependencyResolver;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.external.identity.mapping.ExternalIdentityMappingService;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.supervisor.mapping.SupervisorMappingService;

public class OrganizationAPIImpl {
    private final TenantServiceAccessor tenantAccessor;
    private final int pageSize;

    public OrganizationAPIImpl(TenantServiceAccessor tenantAccessor, int pageSize) {
        this.tenantAccessor = tenantAccessor;
        this.pageSize = pageSize;
    }

    public void deleteOrganization() throws DeletionException {
        ProcessInstanceService processInstanceService = this.tenantAccessor.getProcessInstanceService();
        SCommentService commentService = this.tenantAccessor.getCommentService();
        ActivityInstanceService activityInstanceService = this.tenantAccessor.getActivityInstanceService();
        try {
            boolean canDeleteOrganization;
            QueryOptions queryOptions = new QueryOptions(0, 1);
            boolean bl = canDeleteOrganization = processInstanceService.getNumberOfProcessInstances(queryOptions) == 0L && activityInstanceService.getNumberOfHumanTasks(queryOptions) == 0L && commentService.getNumberOfComments(queryOptions) == 0L;
            if (!canDeleteOrganization) {
                throw new DeletionException("Can't delete a organization when a process, a human tasks, or a comment is active !!.");
            }
            this.deleteOrganizationElements(activityInstanceService);
            this.updateActorProcessDependenciesForAllActors(this.tenantAccessor);
        }
        catch (SBonitaException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    private void deleteOrganizationElements(ActivityInstanceService activityInstanceService) throws SBonitaException {
        IdentityService identityService = this.tenantAccessor.getIdentityService();
        ActorMappingService actorMappingService = this.tenantAccessor.getActorMappingService();
        ProfileService profileService = this.tenantAccessor.getProfileService();
        SupervisorMappingService supervisorService = this.tenantAccessor.getSupervisorService();
        ExternalIdentityMappingService externalIdentityMappingService = this.tenantAccessor.getExternalIdentityMappingService();
        this.deleteCustomUserInfo(identityService);
        actorMappingService.deleteAllActorMembers();
        profileService.deleteAllProfileMembers();
        activityInstanceService.deleteAllPendingMappings();
        activityInstanceService.deleteAllHiddenTasks();
        supervisorService.deleteAllProcessSupervisors();
        externalIdentityMappingService.deleteAllExternalIdentityMappings();
        identityService.deleteAllUserMemberships();
        identityService.deleteAllGroups();
        identityService.deleteAllRoles();
        identityService.deleteAllUsers();
    }

    private void deleteCustomUserInfo(IdentityService identityService) throws SIdentityException {
        List<SCustomUserInfoDefinition> customUserInfoDefinitions = null;
        do {
            customUserInfoDefinitions = identityService.getCustomUserInfoDefinitions(0, this.pageSize);
            this.deleteCustomUserInfo(customUserInfoDefinitions, identityService);
        } while (customUserInfoDefinitions.size() == this.pageSize);
    }

    private void deleteCustomUserInfo(List<SCustomUserInfoDefinition> customUserInfoDefinitions, IdentityService identityService) throws SIdentityException {
        for (SCustomUserInfoDefinition definition : customUserInfoDefinitions) {
            identityService.deleteCustomUserInfoDefinition(definition.getId());
        }
    }

    private void updateActorProcessDependenciesForAllActors(TenantServiceAccessor tenantAccessor) throws SBonitaException {
        List<Long> processDefinitionIds;
        ProcessDefinitionService processDefinitionService = tenantAccessor.getProcessDefinitionService();
        ActorProcessDependencyResolver dependencyResolver = new ActorProcessDependencyResolver();
        do {
            processDefinitionIds = processDefinitionService.getProcessDefinitionIds(0, 100);
            for (Long processDefinitionId : processDefinitionIds) {
                tenantAccessor.getDependencyResolver().resolveDependencies(processDefinitionId, tenantAccessor, dependencyResolver);
            }
        } while (processDefinitionIds.size() == 100);
    }
}

