/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.classloader;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.engine.classloader.BonitaClassLoader;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.ParentClassLoaderResolver;
import org.bonitasoft.engine.classloader.ParentRedirectClassLoader;
import org.bonitasoft.engine.classloader.VirtualClassLoader;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private static final String SEPARATOR = ":";
    private static final String GLOBAL_FOLDER = "global";
    public static final String GLOBAL_TYPE = "GLOBAL";
    public static final long GLOBAL_ID = -1L;
    private static final String LOCAL_FOLDER = "local";
    private final ParentClassLoaderResolver parentClassLoaderResolver;
    private final TechnicalLoggerService logger;
    private final String temporaryFolder;
    private VirtualClassLoader virtualGlobalClassLoader = new VirtualClassLoader("GLOBAL", -1L, VirtualClassLoader.class.getClassLoader());
    private final Map<String, VirtualClassLoader> localClassLoaders = new HashMap<String, VirtualClassLoader>();
    private final Object mutex = new ClassLoaderServiceMutex();
    private boolean shuttingDown = false;

    public ClassLoaderServiceImpl(ParentClassLoaderResolver parentClassLoaderResolver, String temporaryFolder, TechnicalLoggerService logger) {
        this.parentClassLoaderResolver = parentClassLoaderResolver;
        this.logger = logger;
        String temporaryFolderName = this.buildTemporaryFolderName(temporaryFolder);
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        this.temporaryFolder = IOUtil.createTempDirectory(new File(temporaryFolderName, "bonita_engine_" + jvmName).toURI()).getAbsolutePath();
    }

    private String buildTemporaryFolderName(String temporaryFolder) {
        String temporaryFolderName = temporaryFolder;
        if (temporaryFolder.startsWith("${") && temporaryFolder.contains("}")) {
            Pattern pattern = Pattern.compile("^(.*)\\$\\{(.*)\\}(.*)$");
            Matcher matcher = pattern.matcher(temporaryFolder);
            matcher.find();
            StringBuilder sb = new StringBuilder();
            sb.append(matcher.group(1));
            sb.append(System.getProperty(matcher.group(2)));
            sb.append(matcher.group(3));
            temporaryFolderName = sb.toString();
        }
        return temporaryFolderName;
    }

    private String getKey(String type, long id) {
        StringBuffer stb = new StringBuffer();
        stb.append(type);
        stb.append(SEPARATOR);
        stb.append(id);
        return stb.toString();
    }

    @Override
    public long getGlobalClassLoaderId() {
        return -1L;
    }

    @Override
    public String getGlobalClassLoaderType() {
        return GLOBAL_TYPE;
    }

    private VirtualClassLoader getVirtualGlobalClassLoader() {
        return this.virtualGlobalClassLoader;
    }

    @Override
    public ClassLoader getGlobalClassLoader() {
        return this.getVirtualGlobalClassLoader();
    }

    private void warnOnShuttingDown(String key) {
        if (this.shuttingDown && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "Using local classloader on after ClassLoaderService shuttingdown: " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader getLocalClassLoader(String type, long id) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getLocalClassLoader"));
        }
        NullCheckingUtil.checkArgsNotNull(id, type);
        String key = this.getKey(type, id);
        this.warnOnShuttingDown(key);
        if (!this.localClassLoaders.containsKey(key)) {
            Object object = this.mutex;
            synchronized (object) {
                if (!this.localClassLoaders.containsKey(key)) {
                    VirtualClassLoader virtualClassLoader = new VirtualClassLoader(type, id, new ParentRedirectClassLoader(this.getGlobalClassLoader(), this.parentClassLoaderResolver, this, type, id));
                    this.localClassLoaders.put(key, virtualClassLoader);
                }
            }
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getLocalClassLoader"));
        }
        return this.localClassLoaders.get(key);
    }

    @Override
    public void removeLocalClassLoader(String type, long id) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeLocalClassLoader") + ": Removing local classloader for type " + type + " of id " + id);
        }
        NullCheckingUtil.checkArgsNotNull(id, type);
        String key = this.getKey(type, id);
        this.destroyLocalClassLoader(key);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeLocalClassLoader"));
        }
    }

    private URI getGlobalTemporaryFolder() {
        StringBuffer stb = new StringBuffer(this.temporaryFolder);
        stb.append(File.separator);
        stb.append(GLOBAL_FOLDER);
        return new File(stb.toString()).toURI();
    }

    private URI getLocalTemporaryFolder(String artifactType, long artifactId) {
        StringBuffer stb = new StringBuffer(this.temporaryFolder);
        stb.append(File.separator);
        stb.append(LOCAL_FOLDER);
        stb.append(File.separator);
        stb.append(artifactType);
        stb.append(File.separator);
        stb.append(artifactId);
        return new File(stb.toString()).toURI();
    }

    @Override
    public void removeAllLocalClassLoaders(String application) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeAllLocalClassLoaders"));
        }
        NullCheckingUtil.checkArgsNotNull(application);
        HashSet<String> keySet = new HashSet<String>(this.localClassLoaders.keySet());
        for (String key : keySet) {
            if (!key.startsWith(application + SEPARATOR)) continue;
            this.destroyLocalClassLoader(key);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeAllLocalClassLoaders"));
        }
    }

    private void destroyLocalClassLoader(String key) {
        VirtualClassLoader localClassLoader = this.localClassLoaders.get(key);
        if (localClassLoader != null) {
            localClassLoader.destroy();
            this.localClassLoaders.remove(key);
        }
    }

    public String getTemporaryFolder() {
        return this.temporaryFolder;
    }

    @Override
    public void refreshGlobalClassLoader(Map<String, byte[]> resources) {
        VirtualClassLoader virtualClassloader = (VirtualClassLoader)this.getGlobalClassLoader();
        this.refreshLocalClassLoader(virtualClassloader, resources, this.getGlobalClassLoaderType(), this.getGlobalClassLoaderId(), this.getGlobalTemporaryFolder(), ClassLoaderServiceImpl.class.getClassLoader());
    }

    @Override
    public void refreshLocalClassLoader(String type, long id, Map<String, byte[]> resources) {
        VirtualClassLoader virtualClassloader = (VirtualClassLoader)this.getLocalClassLoader(type, id);
        this.refreshLocalClassLoader(virtualClassloader, resources, type, id, this.getLocalTemporaryFolder(type, id), new ParentRedirectClassLoader(this.getGlobalClassLoader(), this.parentClassLoaderResolver, this, type, id));
    }

    private void refreshLocalClassLoader(VirtualClassLoader virtualClassloader, Map<String, byte[]> resources, String type, long id, URI temporaryFolder, ClassLoader parent) {
        virtualClassloader.destroy();
        BonitaClassLoader classloader = new BonitaClassLoader(resources, type, id, temporaryFolder, parent);
        virtualClassloader.setClassLoader(classloader);
    }

    @Override
    public void start() throws SBonitaException {
        this.shuttingDown = false;
        this.virtualGlobalClassLoader = new VirtualClassLoader(GLOBAL_TYPE, -1L, VirtualClassLoader.class.getClassLoader());
    }

    @Override
    public void stop() throws SBonitaException {
        this.shuttingDown = true;
        this.destroyAllLocalClassLoaders();
        this.virtualGlobalClassLoader.destroy();
    }

    private void destroyAllLocalClassLoaders() {
        for (VirtualClassLoader classLoader : this.localClassLoaders.values()) {
            classLoader.destroy();
        }
        this.localClassLoaders.clear();
    }

    @Override
    public void pause() throws SBonitaException {
    }

    @Override
    public void resume() throws SBonitaException {
    }

    private static final class ClassLoaderServiceMutex {
        private ClassLoaderServiceMutex() {
        }
    }
}

