/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import org.bonitasoft.engine.commons.JavaMethodInvoker;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;

public class JavaMethodOperationExecutorStrategy
implements OperationExecutorStrategy {
    public static final String TYPE_JAVA_METHOD = "JAVA_METHOD";

    @Override
    public Object computeNewValueForLeftOperand(SOperation operation, Object valueToSetObjectWith, SExpressionContext expressionContext) throws SOperationExecutionException {
        String dataToSet = operation.getLeftOperand().getName();
        Object objectToInvokeJavaMethodOn = expressionContext.getInputValues().get(dataToSet);
        if (objectToInvokeJavaMethodOn == null) {
            throw new SOperationExecutionException("data " + dataToSet + " does not exist");
        }
        String[] split = operation.getOperator().split(":", 2);
        String operator = split[0];
        String className = null;
        if (split.length > 1) {
            className = split[1];
        }
        try {
            return new JavaMethodInvoker().invokeJavaMethod(operation.getRightOperand().getReturnType(), valueToSetObjectWith, objectToInvokeJavaMethodOn, operator, className);
        }
        catch (Exception e) {
            throw new SOperationExecutionException("Unable to evaluate operation " + operation, e);
        }
    }

    @Override
    public String getOperationType() {
        return TYPE_JAVA_METHOD;
    }
}

