/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.util.Map;
import org.bonitasoft.engine.identity.ExportedCustomUserInfoValue;
import org.bonitasoft.engine.identity.ExportedUserBuilder;
import org.bonitasoft.engine.identity.ExportedUserBuilderFactory;
import org.bonitasoft.engine.identity.xml.XMLContactDataMapping;
import org.bonitasoft.engine.xml.ElementBinding;

public class UserBinding
extends ElementBinding {
    private ExportedUserBuilder userBuilder;
    private boolean containsEnabled = false;

    @Override
    public void setAttributes(Map<String, String> attributes) {
        String userName = attributes.get("userName");
        this.userBuilder = ExportedUserBuilderFactory.createNewInstance(userName, null);
    }

    @Override
    public void setChildElement(String name, String value, Map<String, String> attributes) {
        if ("password".equals(name)) {
            this.userBuilder.setPassword(value);
            String encrypted = attributes.get("encrypted");
            this.userBuilder.setPasswordEncrypted(Boolean.parseBoolean(encrypted));
        } else if ("firstName".equals(name)) {
            this.userBuilder.setFirstName(value);
        } else if ("lastName".equals(name)) {
            this.userBuilder.setLastName(value);
        } else if ("iconName".equals(name)) {
            this.userBuilder.setIconName(value);
        } else if ("iconPath".equals(name)) {
            this.userBuilder.setIconPath(value);
        } else if ("title".equals(name)) {
            this.userBuilder.setTitle(value);
        } else if ("jobTitle".equals(name)) {
            this.userBuilder.setJobTitle(value);
        } else if ("manager".equals(name)) {
            this.userBuilder.setManagerUserName(value);
        } else if ("enabled".equals(name)) {
            this.containsEnabled = true;
            this.userBuilder.setEnabled(Boolean.parseBoolean(value));
        }
    }

    @Override
    public void setChildObject(String name, Object value) {
        ExportedCustomUserInfoValue customUserInfoValue;
        if ("personalData".equals(name)) {
            XMLContactDataMapping personalData = (XMLContactDataMapping)value;
            if (personalData != null) {
                this.userBuilder.setPersonalData(personalData.getContactData());
            }
        } else if ("professionalData".equals(name)) {
            XMLContactDataMapping professionalData = (XMLContactDataMapping)value;
            if (professionalData != null) {
                this.userBuilder.setProfessionalData(professionalData.getContactData());
            }
        } else if ("customUserInfoValue".equals(name) && (customUserInfoValue = (ExportedCustomUserInfoValue)value) != null) {
            this.userBuilder.addCustomUserInfoValue(customUserInfoValue);
        }
    }

    @Override
    public Object getObject() {
        if (!this.containsEnabled) {
            this.userBuilder.setEnabled(true);
        }
        return this.userBuilder.done();
    }

    @Override
    public String getElementTag() {
        return "user";
    }
}

