/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile;

import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.exception.ExecutionException;
import org.bonitasoft.engine.profile.ProfileImportStategy;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileUpdateBuilder;
import org.bonitasoft.engine.profile.builder.SProfileUpdateBuilderFactory;
import org.bonitasoft.engine.profile.exception.profile.SProfileUpdateException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryDeletionException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberDeletionException;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class ReplaceDuplicateImportStrategy
extends ProfileImportStategy {
    public ReplaceDuplicateImportStrategy(ProfileService profileService) {
        super(profileService);
    }

    @Override
    public void beforeImport() throws ExecutionException {
    }

    @Override
    public SProfile whenProfileExists(long importerId, ExportedProfile exportedProfile, SProfile existingProfile) throws ExecutionException, SProfileEntryDeletionException, SProfileMemberDeletionException, SProfileUpdateException {
        this.getProfileService().deleteAllProfileMembersOfProfile(existingProfile);
        if (exportedProfile.isDefault() || existingProfile.isDefault()) {
            return this.getProfileService().updateProfile(existingProfile, this.getProfileUpdateDescriptor(exportedProfile, importerId, false));
        }
        this.getProfileService().deleteAllProfileEntriesOfProfile(existingProfile);
        return this.getProfileService().updateProfile(existingProfile, this.getProfileUpdateDescriptor(exportedProfile, importerId, true));
    }

    @Override
    public boolean canCreateProfileIfNotExists(ExportedProfile exportedProfile) {
        return !exportedProfile.isDefault();
    }

    EntityUpdateDescriptor getProfileUpdateDescriptor(ExportedProfile exportedProfile, long importerId, boolean updateAllProfile) {
        SProfileUpdateBuilder updateBuilder = BuilderFactory.get(SProfileUpdateBuilderFactory.class).createNewInstance();
        updateBuilder.setLastUpdateDate(System.currentTimeMillis()).setLastUpdatedBy(importerId);
        if (updateAllProfile) {
            updateBuilder.setDescription(exportedProfile.getDescription());
        }
        return updateBuilder.done();
    }
}

