/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SearchFields;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.search.Sort;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.search.impl.SearchFilter;
import org.bonitasoft.engine.search.impl.SearchResultImpl;

public abstract class AbstractSearchEntity<C extends Serializable, S extends PersistentObject>
implements TransactionContentWithResult<SearchResult<C>> {
    private final SearchOptions options;
    private final SearchEntityDescriptor searchDescriptor;
    private long count;
    private List<C> clientObjects;

    public AbstractSearchEntity(SearchEntityDescriptor searchDescriptor, SearchOptions options) {
        this.searchDescriptor = searchDescriptor;
        this.options = options;
    }

    @Override
    public void execute() throws SBonitaException {
        List<Object> serverObjects;
        if (this.options == null) {
            throw new SBonitaSearchException("SearchOptions cannot be null");
        }
        int numberOfResults = this.options.getMaxResults();
        int fromIndex = this.options.getStartIndex();
        List filters = this.options.getFilters();
        ArrayList<FilterOption> filterOptions = new ArrayList<FilterOption>(filters.size());
        for (SearchFilter filter : filters) {
            FilterOption option = this.searchDescriptor.getEntityFilter(filter);
            if (option == null) continue;
            filterOptions.add(option);
        }
        String searchTerm = this.options.getSearchTerm();
        SearchFields userSearchTerm = null;
        if (searchTerm != null) {
            userSearchTerm = this.searchDescriptor.getEntitySearchTerm(searchTerm);
        }
        ArrayList<OrderByOption> orderOptions = new ArrayList<OrderByOption>();
        List sorts = this.options.getSorts();
        for (Sort sort : sorts) {
            OrderByOption order = this.searchDescriptor.getEntityOrder(sort);
            orderOptions.add(order);
        }
        QueryOptions countOptions = new QueryOptions(0, Integer.MAX_VALUE, null, filterOptions, userSearchTerm);
        this.count = this.executeCount(countOptions);
        if (this.count > 0L && numberOfResults != 0) {
            if ((long)fromIndex >= this.count) {
                List list = Collections.emptyList();
            }
            QueryOptions searchOptions = new QueryOptions(fromIndex, numberOfResults, orderOptions, filterOptions, userSearchTerm);
            serverObjects = this.executeSearch(searchOptions);
        } else {
            serverObjects = Collections.emptyList();
        }
        this.clientObjects = this.convertToClientObjects(serverObjects);
    }

    public abstract long executeCount(QueryOptions var1) throws SBonitaSearchException;

    public abstract List<S> executeSearch(QueryOptions var1) throws SBonitaSearchException;

    public abstract List<C> convertToClientObjects(List<S> var1);

    @Override
    public SearchResult<C> getResult() {
        return new SearchResultImpl(this.count, this.clientObjects);
    }

    protected SearchFilter getSearchFilter(SearchOptions searchOptions, String searchedKey) {
        for (SearchFilter searchFilter : searchOptions.getFilters()) {
            if (!searchedKey.equals(searchFilter.getField())) continue;
            return searchFilter;
        }
        return null;
    }
}

